

<?php $__env->startSection('title'); ?>
    Edit Assignment
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-title'); ?>
    Edit Assignment
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-navigation'); ?>
    <li><a class="text-decoration-none" href="<?php echo e(route('allAssignments')); ?>">List Assignments </a></li>
    <li>Edit Assignment</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-questions'); ?>
    <button class="btn btn-outline-primary" id="addGroup"><i class="fa-solid fa-plus me-2"></i>Add Group</button>
    <button type="button" class="btn btn-outline-primary" id="addQuestionbtn" data-bs-toggle="modal"
        data-bs-target="#addQuestionModal">
        <i class="fa-solid fa-plus me-2"></i>
        Add Question
    </button>
    <button type="button" class="btn btn-outline-danger" onclick="resetData()">
        <i class="fa-solid fa-triangle-exclamation  me-2"></i>
        Reset Assignment
    </button>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-tabs-li'); ?>
    <li class="nav-item d-flex align-items-center" role="presentation">
        <button class="nav-link active" id="G0" data-bs-toggle="pill" data-bs-target="#fristAssingmentGroup0" type="button"
            role="tab" aria-controls="fristAssingmentGroup0" aria-selected="true">
            <input type="text" class="form-control border-0 groupName" onkeyup='renameGroup(this,"0")'
                placeholder="Enter Group Title ...">
        </button>
        <i class="fa-regular fa-circle-xmark text-danger" onclick='deleteGroup(1)'></i>
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form'); ?>
    <form method="POST" action="<?php echo e(route('updateAssignment', $assignment->id)); ?>" id="FormTabs" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="form-group">
            <label for="assignment_title">Assignment Title</label>
            <input type="text" class="form-control" id="assignment_title" aria-describedby="nameHelp"
                placeholder="Assignment Title" name="assignment_title" value="<?php echo e(old('assignment_title') ?? $assignment->assignment_title); ?>" required>
        </div>
        <div class="form-group">
            <label for="assignment_note">Assignment Note</label>
            <input type="text" class="form-control" id="assignment_note" aria-describedby="assignment_note"
                placeholder="Assignment Note" name="assignment_note" value="<?php echo e(old('assignment_note') ?? $assignment->assignment_note); ?>" required>
        </div>
        
        <input type="hidden" id="assignment_structure" name="assignment_structure" value="">
        <p><?php echo e($assignment->assignment_structure); ?></p>
    <?php $__env->stopSection(); ?>
    
    <?php $__env->startSection('form-tabs-content'); ?>


        
        <div class="tab-pane fade show active px-3" id="fristAssingmentGroup0" role="tabpanel" aria-labelledby="G0">


        </div>

        <div class="col-12 mt-4">

            <button class="btn btn-primary" type="submit" onclick="send_array_data()">save</button>
        </div>
    </form>
<?php $__env->stopSection(); ?>


<!-- Modal -->
<?php $__env->startSection('form-model'); ?>

    <div class="modal fade" id="addQuestionModal" tabindex="-1" aria-labelledby="addQuestionModalLabel"
        aria-hidden="true" style="z-index: 10000000000;">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addQuestionModalLabel">Add Question</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="bg-white rounded shadow p-4">

                        <div class="table-responsive">
                            <table id="questions" class="table table-striped table-middle  table-bordered mt-3 "
                                style="width:100%">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col" class="d-none">id</th>
                                        <th scope="col">Question Title</th>
                                        <th scope="col">Answers</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <p class="m-0 px-3">1</p>
                                            </td>
                                            <td class="d-none">
                                                <?php echo e($question->id); ?>

                                            </td>

                                            <td>
                                                <a class="text-decoration-none"
                                                    href="<?php echo e(route('viewQuestion', $question->id)); ?>">
                                                    <p class="text-primary m-0 px-3 "><?php echo e($question->question_title); ?></p>
                                                </a>
                                            </td>
                                            <td class="d-flex justify-content-center">
                                                <?php $__currentLoopData = json_decode($question->answers); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-check">
                                                        <label class="form-check-label text-center">

                                                            <input type="radio" disabled
                                                                class="form-check-input d-block m-auto my-2" name="answer"
                                                                id="q1" value="value">

                                                            <p class="my-2" id="<?php echo e($Answer->answer_index); ?>">
                                                                <?php echo e($Answer->answer_text); ?></p>
                                                        </label>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>


                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>

                            </table>
                        </div>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal"
                        id="selectedButton">insert</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        var questions = <?php echo json_encode($questions); ?>;
        var assignmentEdit = <?php echo json_encode($assignment->assignment_structure); ?>;
    </script>
    <script src="<?php echo e(asset('js/assignment.js')); ?>"></script>
<?php $__env->stopSection(); ?>






<?php echo $__env->make('layouts.assigment_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/assignments/edit.blade.php ENDPATH**/ ?>