

<?php $__env->startSection('title'); ?>
    View Business Location
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-title'); ?>
    View Business Location - <?php echo e($business_location->business_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-navigation'); ?>
    <li><a class="text-decoration-none" href="<?php echo e(route('allBusinessLocations')); ?>">List Business Location</a></li>
    <li>View Business Location</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-panel'); ?>
    <div class="user-avtar">
        <?php if($business_location->image !== null): ?>
            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;"
                src='<?php echo e(asset("uploads/$business_location->image")); ?>' alt="<?php echo e($business_location->business_name); ?>">
        <?php else: ?>
            <span><?php echo e(ucfirst($business_location->business_name[0])); ?></span>
        <?php endif; ?>
    </div>
    <div class="user-details text-center pt-3">
        <h3><?php echo e($business_location->business_name); ?></h3>
        <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

            <button class="nav-link active" id="pills-business-location-info-tab" data-bs-toggle="pill"
                data-bs-target="#pills-business-location-info" type="button" role="tab"
                aria-controls="pills-business-location-info" aria-selected="true">
                <i class="fa-solid fa-circle-exclamation"></i><span>Business Location Info</span>
            </button>
            <button class="nav-link" id="v-pills-business-location-license-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-business-location-license" type="button" role="tab"
                aria-controls="v-pills-business-location-license" aria-selected="false"><i
                    class="fa-solid fa-address-book"></i><span>License Info</span></button>
            <button class="nav-link" id="v-pills-business-location-ownership-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-business-location-ownership" type="button" role="tab"
                aria-controls="v-pills-business-location-ownership" aria-selected="false"><i
                    class="fa-solid fa-link"></i><span>Ownership User Info</span></button>
            <a class="nav-link" type="button" role="tab" aria-selected="false"
                href="<?php echo e(route('editBusinessLocation', $business_location->id)); ?>"><i
                    class="fa-solid fa-user-pen"></i><span>Edit
                    Business Location</span></a>
            
            <button class="nav-link" id="v-pills-business-location-sendwhatsapp-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-business-location-sendwhatsapp" type="button" role="tab"
                aria-controls="v-pills-business-location-sendwhatsapp" aria-selected="false"><i
                    class="fa-solid fa-envelope"></i> <span>Send WhatsApp</span></button>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('view-tabs'); ?>
    
    <div class="tab-pane fade show active" id="pills-business-location-info" role="tabpanel"
        aria-labelledby="pills-business-location-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Business Location Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Business Name</td>
                            <td><?php echo e($business_location->business_name); ?></td>
                        </tr>
                        <tr>
                            <td>Business Address</td>
                            <td><?php echo e($business_location->address); ?></td>
                        </tr>
                        <tr>
                            <td>Email Address</td>
                            <td><?php echo e($business_location->email); ?></td>
                        </tr>
                        <tr>
                            <td>Mobile Number</td>
                            <td><?php echo e($business_location->phone); ?></td>
                        </tr>
                        <tr>
                            <td>Alternative Mobile Number</td>
                            <td><?php echo e($business_location->alternative_phone); ?></td>
                        </tr>
                        <tr>
                            <td>Status</td>
                            <td>
                                <?php if($business_location->is_active == 'Active'): ?>
                                    <span class="text-success"><?php echo e($business_location->is_active); ?></span>
                                <?php else: ?>
                                    <span class="text-danger"><?php echo e($business_location->is_active); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Created By</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e(route('viewUser', $business_location->owner_id)); ?>"><?php echo e($business_location->createdPerson->user_name); ?></a>
                            </td>
                        </tr>
                        <tr>
                            <td>Created Date</td>
                            <td><?php echo e($business_location->created_at); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-business-location-license" role="tabpanel"
        aria-labelledby="v-pills-business-location-license-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">License Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Start Date</td>
                            <td><?php echo e($business_location->license_start_date); ?></td>
                        </tr>
                        <tr>
                            <td>End Date</td>
                            <td><?php echo e($business_location->license_end_date); ?></td>
                        </tr>
                        <tr>
                            <td>Max Assignments</td>
                            <td><?php echo e($business_location->max_assignments); ?></td>
                        </tr>
                        <tr>
                            <td>Max Students</td>
                            <td><?php echo e($business_location->max_students); ?></td>
                        </tr>
                        <tr>
                            <td>Max Submissions</td>
                            <td><?php echo e($business_location->max_submissions); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-business-location-ownership" role="tabpanel"
        aria-labelledby="v-pills-business-location-ownership-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Ownership User Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Ownership Name</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e(route('viewUser', $business_location->owner_id)); ?>"><?php echo e($business_location->owner->full_name); ?></a>
                            </td>
                        </tr>
                        <tr>
                            <td>Ownership Email Address</td>
                            <td><?php echo e($business_location->owner->email); ?></td>
                        </tr>
                        <tr>
                            <td>Ownership Mobile Number</td>
                            <td><?php echo e($business_location->owner->phone); ?></td>
                        </tr>
                        <tr>
                            <td>Ownership Alternative Mobile Number</td>
                            <td><?php echo e($business_location->owner->alternative_phone); ?></td>
                        </tr>
                        <tr>
                            <td>Ownership Contact Number</td>
                            <td><?php echo e($business_location->owner->contact_number); ?></td>
                        </tr>
                        <tr>
                            <td>Status</td>
                            <td>
                                <?php if($business_location->owner->is_active == 'Active'): ?>
                                    <span class="text-success"><?php echo e($business_location->owner->is_active); ?></span>
                                    <span> & </span>
                                    <?php if($business_location->owner->allow_login == 'Allowable'): ?>
                                        <span class="text-success"><?php echo e($business_location->owner->allow_login); ?> To
                                            Login</span>
                                    <?php else: ?>
                                        <span class="text-danger"><?php echo e($business_location->owner->allow_login); ?> To
                                            Login</span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-danger"><?php echo e($business_location->owner->is_active); ?></span>
                                    <span> & </span>
                                    <?php if($business_location->owner->allow_login == 'Allowable'): ?>
                                        <span class="text-success"><?php echo e($business_location->owner->allow_login); ?> To
                                            Login</span>
                                    <?php else: ?>
                                        <span class="text-danger"><?php echo e($business_location->owner->allow_login); ?> To
                                            Login</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    

    
    <div class="tab-pane fade" id="v-pills-business-location-sendwhatsapp" role="tabpanel"
        aria-labelledby="v-pills-business-location-sendwhatsapp-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Send Whatsapp to Business Location
                    Phone
                </div>
            </div>
            <p></p>
            <form>
                <div class="panel-body p-3">
                    <div class="form-group">
                        <label>To</label>
                        <input type="text" value="asdfasd fsdfas" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label>Message</label>
                        <textarea class="form-control" placeholder="Enter Message . . ." id="whatsapp_message" rows="10"></textarea>
                    </div>
                </div>
                <div class="panel-footer text-center">
                    <a class="btn btn-primary" onclick="send_whatsapp()">Send</a>
                    <script>
                        function send_whatsapp() {
                            let mobile = "<?php echo e($business_location->phone); ?>";
                            let message = document.getElementById("whatsapp_message").value;
                            window.open('https://api.whatsapp.com/send?phone=' + mobile + '&text=' + message);
                            // window.location.href = "https://v6.devclinic.tps-egy.com/admin/index.php?route=patient/view&id=4", true;
                        }
                    </script>
                </div>
            </form>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/business-locations/view.blade.php ENDPATH**/ ?>