

<?php $__env->startSection('title'); ?>
Student Assignment
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('inc.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section id="setting">
    <div class="container">
        <form method="POST" action="<?php echo e(route('createStudentAssignment')); ?>" id="FormTabs" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="bg-white overflow-auto  shadow-lg  rounded-lg">
                <h1 class="text-center text-spec py-5 bg-light border-bottom">Setting Your Quiz</h1>
                <div class="p-4">

                    <div class="row mb-3 border-bottom text-capitalize">
                        <?php if($student->student_name !=null): ?>
                        <div class="col-md-6">
                            <h5>student Name: <span class="text-muted fs-6"><?php echo e($student->student_name); ?></span></h5>
                        </div>
                        <?php endif; ?>
                        <?php if($student->dob !=null): ?>
                        <div class="col-md-6">
                            <h5>date Of Birth: <span class="text-muted fs-6"><?php echo e($student->dob); ?></span></h5>
                        </div>
                        <?php endif; ?>
                        <?php if($student->dob !=null): ?>
                        <div class="col-md-6">
                            <h5>age:
                                <span class="text-muted fs-6">

                                    <?php echo e(\Carbon\Carbon::parse($student->dob)->diff(\Carbon\Carbon::now())->format('%y years, %m months and %d days')); ?>

                                </span>
                            </h5>
                        </div>
                        <?php endif; ?>
                        <?php if($student->nationality !=null): ?>
                        <div class="col-md-6">
                            <h5>nationality: <span class="text-muted fs-6"><?php echo e($student->nationality); ?></span></h5>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">

                        <label for="Assignment" class="text-spec">Assignment Title</label>
                        <select id="Assignment" class="form-control" name="assignmentId">
                            <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($assignment->id); ?>"><?php echo e($assignment->assignment_title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group my-3">

                        <label for="informationAssignment" class="text-spec">
                            Based on the information which has been taken from

                        </label>
                        <select id="informationAssignment" multiple class="form-control" name="assignmentInformation" aria-label="multiple select example">
                            <option value="Father">Father</option>
                            <option value="Mother">Mother</option>
                            <option value="Superior">Superior</option>
                            <option value="Teacher">Teacher</option>
                            <option value="Trainer">Trainer</option>
                            <option value="Notes">Notes</option>

                        </select>
                    </div>

                    <div class="form-group">
                        <input type="hidden" class="form-control" name="studentId" value="<?php echo e($student->id); ?>">
                    </div>
                    <button id="startBtn" type="submit" class="btn float-right py-2 px-4 bg-spec rounded-pill text-white my-4">Start
                    </button>
                </div>
            </div>
        </form>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/students/take_assignment.blade.php ENDPATH**/ ?>