

<?php $__env->startSection('title'); ?>
    View User
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-title'); ?>
    <?php echo e(__('users.view_user')); ?> - <?php echo e($user->user_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-navigation'); ?>
    <li><a class="text-decoration-none" href="<?php echo e(route('allUsers')); ?>"><?php echo e(__('users.list_users')); ?></a></li>
    <li><?php echo e(__('users.view_user')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-panel'); ?>
    <div class="user-avtar">
        <?php if($user->image !== null): ?>
            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;"
                src='<?php echo e(asset("uploads/$user->image")); ?>' alt="<?php echo e($user->full_name); ?>">
        <?php else: ?>
            <span><?php echo e(ucfirst($user->full_name[0])); ?></span>
        <?php endif; ?>
    </div>
    <div class="user-details text-center pt-3">
        <h3><?php echo e($user->full_name); ?></h3>
        <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

            <button class="nav-link active" id="v-pills-user-info-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-info" type="button" role="tab" aria-controls="v-pills-user-info"
                aria-selected="true">
                <i class="fa-solid fa-circle-exclamation"></i><span><?php echo e(__('users.basic_info')); ?></span>
            </button>
            <button class="nav-link" id="v-pills-user-address-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-address" type="button" role="tab" aria-controls="v-pills-user-address"
                aria-selected="false"><i class="fa-solid fa-address-book"></i><span><?php echo e(__('users.address_info')); ?></span></button>
            <button class="nav-link" id="v-pills-user-social-media-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-social-media" type="button" role="tab"
                aria-controls="v-pills-user-social-media" aria-selected="false"><i class="fa-solid fa-link"></i><span><?php echo e(__('users.social_links')); ?></span></button>
            <?php if(Auth::user()->role == 'super_admin' || Auth::user()->role == 'owner'): ?>
                <a class="nav-link" type="button" role="tab" aria-selected="false"
                    href="<?php echo e(route('editUser', $user->id)); ?>"><i class="fa-solid fa-user-pen"></i><span><?php echo e(__('users.edit_user')); ?></span></a>
            <?php endif; ?>
            
            <button class="nav-link" id="v-pills-user-sendwhatsapp-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-sendwhatsapp" type="button" role="tab"
                aria-controls="v-pills-user-sendwhatsapp" aria-selected="false"><i class="fa-solid fa-envelope"></i>
                <span><?php echo e(__('users.send_whatsApp')); ?></span></button>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('view-tabs'); ?>
    
    <div class="tab-pane fade show active" id="v-pills-user-info" role="tabpanel" aria-labelledby="v-pills-user-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5"><?php echo e(__('users.basic_info')); ?></div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td><?php echo e(__('users.user_name')); ?></td>
                            <td><?php echo e($user->user_name); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.full_name')); ?></td>
                            <td><?php echo e($user->full_name); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.email_address')); ?></td>
                            <td><?php echo e($user->email); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.mobile_number')); ?></td>
                            <td><?php echo e($user->phone); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.alternative_mobile_number')); ?></td>
                            <td><?php echo e($user->alternative_phone); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.contact_number')); ?></td>
                            <td><?php echo e($user->contact_number); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.dob')); ?></td>
                            <td><?php echo e($user->dob); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.gender')); ?></td>
                            <td><?php echo e($user->gender); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.blood_group')); ?></td>
                            <td><?php echo e($user->blood_group); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.mother_language')); ?></td>
                            <td><?php echo e($user->language); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.nationality')); ?></td>
                            <td><?php echo e($user->nationality); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.national_number')); ?></td>
                            <td><?php echo e($user->national_number); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.marital_status')); ?></td>
                            <td><?php echo e($user->marital_status); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.business_location')); ?></td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e(route('viewBusinessLocation', $user->business_id)); ?>"><?php echo e($user->business_location->business_name); ?></a>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.status')); ?></td>
                            <td>
                                <?php if($user->is_active == 'Active'): ?>
                                    <span class="text-success"><?php echo e($user->is_active); ?></span>
                                <?php else: ?>
                                    <span class="text-danger"><?php echo e($user->is_active); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        
                        <tr>
                            <td><?php echo e(__('users.created_date')); ?></td>
                            <td><?php echo e($user->created_at); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-user-address" role="tabpanel" aria-labelledby="v-pills-user-address-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5"><?php echo e(__('users.address_info')); ?></div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td><?php echo e(__('users.address')); ?></td>
                            <td><?php echo e($user->address); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.city')); ?></td>
                            <td><?php echo e($user->city); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.state')); ?></td>
                            <td><?php echo e($user->state); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.country')); ?></td>
                            <td><?php echo e($user->country); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.landmark')); ?></td>
                            <td><?php echo e($user->landmark); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-user-social-media" role="tabpanel"
        aria-labelledby="v-pills-user-social-media-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5"><?php echo e(__('users.social_links')); ?></div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td><?php echo e(__('users.facebook_link')); ?></td>
                            <td><a class="text-decoration-none" href="<?php echo e($user->fb_link); ?>"><?php echo e($user->fb_link); ?></a>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.twitter_link')); ?></td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($user->twitter_link); ?>"><?php echo e($user->twitter_link); ?></a></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.social_media_link')); ?></td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($user->social_media_1); ?>"><?php echo e($user->social_media_1); ?></a></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('users.social_media_link')); ?></td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($user->social_media_2); ?>"><?php echo e($user->social_media_2); ?></a></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    

    
    <div class="tab-pane fade" id="v-pills-user-sendwhatsapp" role="tabpanel"
        aria-labelledby="v-pills-user-sendwhatsapp-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5"><?php echo e(__('users.send_whatsApp_user')); ?>

                </div>
            </div>
            <p></p>
            <form>
                <div class="panel-body p-3">
                    <div class="form-group">
                        <label><?php echo e(__('users.send_whatsApp_to')); ?></label>
                        <input type="text" value="asdfasd fsdfas" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label><?php echo e(__('users.send_whatsApp_message')); ?></label>
                        <textarea class="form-control" placeholder="Enter Message . . ." id="whatsapp_message" rows="10"></textarea>
                    </div>
                </div>
                <div class="panel-footer text-center">
                    <a class="btn btn-outline-primary" onclick="send_whatsapp()">Send</a>
                    <script>
                        function send_whatsapp() {
                            let mobile = "<?php echo e($user->phone); ?>";
                            let message = document.getElementById("whatsapp_message").value;
                            window.open('https://api.whatsapp.com/send?phone=' + mobile + '&text=' + message);
                            // window.location.href = "https://v6.devclinic.tps-egy.com/admin/index.php?route=patient/view&id=4", true;
                        }
                    </script>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\assignments\resources\views/users/view.blade.php ENDPATH**/ ?>