

<?php $__env->startSection('title'); ?>
View Question
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="px-3">

    <div class="row align-items-center">
        <div class="col-sm-8">
            <h2 class="page-title-text d-inline-block">View Question - <?php echo e($question->question_title); ?></h2>
        </div>
        <div class="col-sm-4 text-right">
            <div class=" text-end mb-3">
                <a href="<?php echo e(route('editQuestion' , $question->id)); ?>" class="btn btn-outline-warning btn-sm me-2">
                    <i class="fa-solid fa-pen-to-square me-2"></i> Edit Question
                </a>  
            </div>
        </div>
    </div>
    <div class="row align-items-center">
        <div class="col-sm-12">
            <div class="breadcrumbs d-inline-block">
                <ul>
                    <li><a class="text-decoration-none" href="#">Home</a></li>
                    <li><a class="text-decoration-none" href="<?php echo e(route('allUsers')); ?>">List Questions </a></li>
                    <li>View Question</li>
                </ul>
            </div>
        </div>
    </div>

    <section class="container px-5">
        <div class="bg-white w-100 m-auto shadow-lg rounded-lg  overflow-auto">
            <div class="p-3 bg-light border-bottom overflow-auto">
                <h1 class="text-spec text-center">Questions</h1>
            </div>
    
            <div class="p-4 text-spec">
                <h2 class="">Q: <?php echo e($question->question_title); ?> </h2>
                <h5 id="question" class="text-muted mb-5"><?php echo e($question->question_note); ?></h5>
    
                <div id="rowAnswer" class="row g-5 px-2">
                    <?php $__currentLoopData = json_decode($question->answers); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-check d-flex justify-content-center col-md-3">
                        <label class="form-check-label text-center">
                            <!-- <?php echo e($loop->index); ?> -->
                            <input type="radio" disabled class="form-check-input d-block m-auto my-2" name="answer" id="q1" value="value">
                           
                         
                            <?php if($Answer->answer_image !== null): ?>
                            <img class="image-fload img-thumbnail"  src='<?php echo e(asset("uploads/$Answer->answer_image")); ?>' alt="<?php echo e($Answer->answer_text); ?>">
                            <?php endif; ?>
    
                            <p class="my-2"> <?php echo e($Answer->answer_text); ?></p>
                        </label>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/questions/view.blade.php ENDPATH**/ ?>