

<?php $__env->startSection('title'); ?>
    Add Assignment
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-title'); ?>
    <?php echo e(__('assignments.add_assignment')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-navigation'); ?>
    <li><a class="text-decoration-none" href="<?php echo e(route('allAssignments')); ?>"><?php echo e(__('assignments.list_assignments')); ?></a></li>
    <li><?php echo e(__('assignments.add_assignment')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-questions'); ?>
    <button class="btn btn-outline-primary" id="addGroup"><i class="fa-solid fa-plus me-2"></i><?php echo e(__('assignments.add_group')); ?></button>
    <button type="button" class="btn btn-outline-primary" id="addQuestionbtn" data-bs-toggle="modal"
        data-bs-target="#addQuestionModal">
        <i class="fa-solid fa-plus me-2"></i>
        <?php echo e(__('assignments.add_question')); ?>

    </button>
    <button type="button" class="btn btn-outline-primary" id="addCondationbtn" data-bs-toggle="modal"
        data-bs-target="#addCondationModal">
        <i class="fa-solid fa-plus me-2"></i>
        <?php echo e(__('assignments.add_condation')); ?>

    </button>

    <button type="button" class="btn btn-outline-danger" onclick="resetData()">
        <i class="fa-solid fa-triangle-exclamation  me-2"></i>
        <?php echo e(__('assignments.reset_assignment')); ?>

    </button>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-tabs-li'); ?>
    <li class="nav-item d-flex align-items-center" role="presentation">

        <button class="nav-link active" id="G0" data-bs-toggle="pill" data-bs-target="#fristAssingmentGroup0"
            type="button" role="tab" aria-controls="fristAssingmentGroup0" aria-selected="true">
            <input type="text" class="form-control border-0 groupName" onkeyup='renameGroup(this,"0")'
                placeholder="Enter Group Title ...">
                <input type="text" class="form-control border-0 groupName" onkeyup='renameGroupAR(this,"0")'  placeholder="عنوان الجروب ...">
        </button>

        <i class="fa-regular fa-circle-xmark text-danger" onclick='deleteGroup(1)'></i>
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form'); ?>
    <form method="POST" action="<?php echo e(route('storeAssignment')); ?>" id="FormTabs" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>


        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="english-tab" data-bs-toggle="tab" data-bs-target="#english"
                    type="button" role="tab" aria-controls="english" aria-selected="true">English</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="arabic-tab" data-bs-toggle="tab" data-bs-target="#arabic" type="button"
                    role="tab" aria-controls="arabic" aria-selected="false">العربي</button>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="english" role="tabpanel" aria-labelledby="english-tab">
                <div class="form-group">
                    <label for="assignment_title">Assignment Title</label>
                    <input type="text" class="form-control" id="assignment_title" aria-describedby="nameHelp"
                        placeholder="Assignment Title" name="assignment_title" value="<?php echo e(old('assignment_title')); ?>"
                        required>
                </div>
                <div class="form-group">
                    <label for="assignment_shortname">Assignment Short Name</label>
                    <input type="text" class="form-control" id="assignment_shortname" aria-describedby="nameHelp"
                        placeholder="Assignment Short Name" name="assignment_shortname"
                        value="<?php echo e(old('assignment_shortname')); ?>" required>
                </div>
                <div class="form-group">
                    <label for="assignment_note">Assignment Note</label>
                    <textarea class="form-control text-start" id="assignment_note" aria-describedby="assignment_note"
                        placeholder="Enter Assignment Note ..." name="assignment_note" rows="3"><?php echo e(old('assignment_note')); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="assignment_instructions">Assignment Instructions</label>
                    <textarea class="form-control text-start" id="assignment_instructions" aria-describedby="assignment_instructions"
                        placeholder="Enter Assignment Instructions ..." name="assignment_instructions" rows="3"><?php echo e(old('assignment_instructions')); ?></textarea>
                </div>
            </div>
            <div class="tab-pane fade" id="arabic" role="tabpanel" aria-labelledby="arabic-tab">
                <div class="form-group">
                    <label for="assignment_title_ar">عنوان الاستمارة</label>
                    <input type="text" class="form-control" id="assignment_title_ar" aria-describedby="nameHelp"
                        placeholder="عنوان الاستمارة ..." name="assignment_title_ar"
                        value="<?php echo e(old('assignment_title_ar')); ?>">
                </div>
                <div class="form-group">
                    <label for="assignment_note_ar">ملاحظات الاستمارة</label>
                    <textarea class="form-control text-start" aria-describedby="assignment_note_ar" id="assignment_note_ar"
                        placeholder="ملاحظات الاستمارة ..." name="assignment_note_ar" rows="3"><?php echo e(old('assignment_note_ar')); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="assignment_instructions_ar">تعليمات الاستمارة</label>
                    <textarea class="form-control text-start" id="assignment_instructions_ar"
                        aria-describedby="assignment_instructions_ar" placeholder="تعليمات الاستمارة ..."
                        name="assignment_instructions_ar" rows="3"><?php echo e(old('assignment_instructions_ar')); ?></textarea>
                </div>
            </div>
        </div>


        

        <input type="hidden" id="assignment_structure" name="assignment_structure" value="5">
        <input type="hidden" id="assignment_questions" name="assignment_questions" value="5">
        <input type="hidden" id="assignment_condition" name="assignment_condition" value="5">
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('form-tabs-content'); ?>
        
        <div class="tab-pane fade show active  px-3" id="fristAssingmentGroup0" role="tabpanel" aria-labelledby="G0">


        </div>
        
        

        <div class="col-12 mt-4">

            <button class="btn btn-outline-primary" type="submit" onclick="send_array_data()"><?php echo e(__('assignments.save')); ?></button>
        </div>

    </form>
<?php $__env->stopSection(); ?>


<!-- Modal -->
<?php $__env->startSection('form-model'); ?>
    <div class="modal fade" id="addQuestionModal" tabindex="-1" aria-labelledby="addQuestionModalLabel"
        aria-hidden="true" style="z-index: 10000000000;">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addQuestionModalLabel"><?php echo e(__('assignments.add_question')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="bg-white rounded shadow p-4">

                        <div class="table-responsive">
                            <table id="questions" class="table table-striped table-middle  table-bordered mt-3 "
                                style="width:100%">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col" class="d-none">id</th>
                                        <th scope="col"><?php echo e(__('assignments.question_title')); ?></th>
                                        <th scope="col"><?php echo e(__('assignments.answers')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <p class="m-0 px-3">1</p>
                                            </td>
                                            <td class="d-none">
                                                <?php echo e($question->id); ?>

                                            </td>

                                            <td>
                                                <p class="text-custome m-0 px-3 "><?php echo e($question->question_title); ?></p>
                                                
                                            </td>
                                            <td class="d-flex justify-content-center">
                                                <?php $__currentLoopData = json_decode($question->answers); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-check">
                                                        <label class="form-check-label text-center">

                                                            <input type="radio" disabled
                                                                class="form-check-input d-block m-auto my-2"
                                                                name="answer" id="q1" value="value">

                                                            <p class="my-2" id="<?php echo e($Answer->answer_index); ?>">
                                                                <?php echo e($Answer->answer_text); ?></p>
                                                        </label>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>


                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>

                            </table>
                        </div>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('assignments.close')); ?></button>
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal"
                        id="selectedButton"><?php echo e(__('assignments.insert')); ?></button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="addCondationModal" tabindex="-1" aria-labelledby="addCondationModalLabel"
        aria-hidden="true" style="z-index: 10000000000;">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addCondationModalLabel"><?php echo e(__('assignments.add_condation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="bg-white rounded shadow p-4 d-flex flex-wrap justify-content-around">
                        <div class="col-4">
                            <label for=""><?php echo e(__('assignments.age_condation')); ?></label>
                            <select name="" id="ageCondation" class="form-control">
                                <option value=">"><?php echo e(__('assignments.greater_than')); ?></option>
                                <option value=">="><?php echo e(__('assignments.greater_than_or_equal')); ?></option>
                                <option value="<"><?php echo e(__('assignments.smaller_than')); ?></option>
                                <option value="<="><?php echo e(__('assignments.smaller_than_or_equal')); ?></option>
                                <option value="=="><?php echo e(__('assignments.equal')); ?></option>
                            </select>

                        </div>
                        <div class="col-6">

                            <label for=""><?php echo e(__('assignments.age')); ?></label>
                            <input type="number" id="studentage" class="form-control">
                        </div>
                        <div class="col-12 mt-2">

                            <label for=""><?php echo e(__('assignments.alert_message')); ?></label>
                            <input type="text" id="alert_message" class="form-control">
                        </div>


                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('assignments.close')); ?></button>
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal"
                        onclick="insertCondation()"><?php echo e(__('assignments.insert')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>
    <script>
        var assignmentEdit = null;
        var questions = <?php echo json_encode($questions); ?>;
    </script>
    <script src="<?php echo e(asset('js/assignment.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.assigment_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Bahaaaaa\assignments\resources\views/assignments/create.blade.php ENDPATH**/ ?>