

<?php $__env->startSection('title'); ?>
    All Trainers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    Trainers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li>Trainers</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createTrainer')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Trainer
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
<th scope="col">#</th>
<th scope="col">Image</th>
<th scope="col">Trainer</th>
<th scope="col">Gender</th>
<th scope="col">Nationality</th>
<th scope="col">Business Location</th>
<th scope="col">Created By</th>
<th scope="col">Actions</th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
<?php $__currentLoopData = $trainers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr>
    <td>
        <p class="m-0 px-3">1</p>
    </td>
    <th scope="row">
        <?php if($trainer->image !== null): ?>
            <img class="image-fload" width="100px" height="100px"
                src='<?php echo e(asset("uploads/$trainer->image")); ?>'
                alt="<?php echo e($trainer->full_name); ?>">
        <?php else: ?>
            No Trainer Image
        <?php endif; ?>
    </th>
    <td>
        <a class="text-decoration-none" href="<?php echo e(route('viewTrainer', $trainer->id)); ?>">
            <p class="text-primary m-0 px-3"><?php echo e($trainer->full_name); ?></p>
        </a>
        <p class="m-0 px-3"><?php echo e($trainer->email); ?></p>
        <p class="m-0 px-3"><?php echo e($trainer->phone); ?></p>
    </td>
    <td>
        <p class="m-0 px-3"><?php echo e($trainer->gender); ?></p>
    </td>
    <td>
        <p class="m-0 px-3"><?php echo e($trainer->nationality); ?></p>
    </td>
    <td>
        <a class="text-decoration-none" href="<?php echo e(route('viewBusinessLocation', $trainer->business_id)); ?>">
            <p class="m-0 px-3"><?php echo e($trainer->businessLocation->business_name); ?></p>
        </a>
    </td>
    <td>
        <a class="text-decoration-none" href="<?php echo e(route('viewUser', $trainer->created_by)); ?>">
            <p class="m-0 px-3"><?php echo e($trainer->users->user_name); ?></p>
        </a>
    </td>
    <td>
        <div class="btn-group">

            <i data-bs-toggle="dropdown" aria-expanded="false"
                class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

            <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                <li>
                    <a class="dropdown-item opacity-75 "
                        href="<?php echo e(route('viewTrainer', $trainer->id)); ?>">
                        <i class="fa-solid fa-eye me-2 text-primary"></i>
                        View
                    </a>
                </li>
                <li>
                    <a class="dropdown-item opacity-75 "
                        href="<?php echo e(route('editTrainer', $trainer->id)); ?>">
                        <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                        Edit
                    </a>
                </li>
                <li>
                    <a class="dropdown-item opacity-75 "
                        href="<?php echo e(route('deleteTrainer', $trainer->id)); ?>">
                        <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                        Delete
                    </a>
                </li>
            </ul>
        </div>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/trainers/list.blade.php ENDPATH**/ ?>