

<?php $__env->startSection('title'); ?>
View student
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-title'); ?>
<?php echo e(__('students.view_user')); ?> - <?php echo e($student -> student_name); ?>

<i class="fa-solid fa-print text-custome" onclick="printData()"></i>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-navigation'); ?>
<li><a class="text-decoration-none" href="<?php echo e(route('allStudents')); ?>"><?php echo e(__('students.list_students')); ?></a></li>
<li><?php echo e(__('students.view_user')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-panel'); ?>
<div class="user-avtar" id="userImage">
    <?php if($student->image !== null): ?>
    <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='<?php echo e(asset("uploads/$student->image")); ?>' alt="<?php echo e($student->full_name); ?>">
    <?php else: ?>
    <span><?php echo e(ucfirst($student->student_name[0])); ?></span>
    <?php endif; ?>
</div>
<div class="user-details text-center pt-3">
    <h3 id="userName"><?php echo e($student->student_name); ?></h3>
    <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

        <button class="nav-link active" id="pills-student-info-tab" data-bs-toggle="pill" data-bs-target="#pills-student-info" type="button" role="tab" aria-controls="pills-student-info" aria-selected="true">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.list_students')); ?></span>
        </button>

        <button class="nav-link" id="v-pills-student-address-tab" data-bs-toggle="pill" data-bs-target="#v-pills-student-address" type="button" role="tab" aria-controls="v-pills-student-address" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.address_info')); ?></span>
        </button>

        <button class="nav-link" id="v-pills-father-tab" data-bs-toggle="pill" data-bs-target="#v-pills-father" type="button" role="tab" aria-controls="v-pills-father" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.father')); ?></span>
        </button>

        <button class="nav-link" id="v-pills-mother-tab" data-bs-toggle="pill" data-bs-target="#v-pills-mother" type="button" role="tab" aria-controls="v-pills-mother" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.mother')); ?></span>
        </button>
        <?php if($student->superior =='Yes'): ?>
        <button class="nav-link" id="v-pills-superior-tab" data-bs-toggle="pill" data-bs-target="#v-pills-superior" type="button" role="tab" aria-controls="v-pills-superior" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.superior')); ?></span>
        </button>
        <?php endif; ?>

        <button class="nav-link" id="v-pills-main-complaint-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main-complaint" type="button" role="tab" aria-controls="v-pills-main-complaint" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.main_problem')); ?></span>
        </button>


        <button class="nav-link" id="v-pills-relation_family-history-tab" data-bs-toggle="pill" data-bs-target="#v-pills-family-history" type="button" role="tab" aria-controls="v-pills-family-history" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.family_history')); ?></span>
        </button>

        <button class="nav-link" id="v-pills-economic_situation-tab" data-bs-toggle="pill" data-bs-target="#v-pills-economic_situation" type="button" role="tab" aria-controls="v-pills-economic_situation" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.economic_situation')); ?></span>
        </button>

        <button class="nav-link" id="v-pills-organic-growth-history-tab" data-bs-toggle="pill" data-bs-target="#v-pills-organic-growth-history" type="button" role="tab" aria-controls="v-pills-organic-growth-history" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.organic_growth_history')); ?></span>
        </button>

        <button class="nav-link" id="v-pills-psychological-and-behavioral-side-tab" data-bs-toggle="pill" data-bs-target="#v-pills-psychological-and-behavioral-side" type="button" role="tab" aria-controls="v-pills-psychological-and-behavioral-side" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.psychological_and_behavioral_side')); ?></span>
        </button>

        <button class="nav-link" id="v-pills-Linguistic-side-tab" data-bs-toggle="pill" data-bs-target="#v-pills-Linguistic-side" type="button" role="tab" aria-controls="v-pills-Linguistic-side" aria-selected="false">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span><?php echo e(__('students.linguistic_side')); ?></span>
        </button>


        <button class="nav-link" id="v-pills-student-social-media-tab" data-bs-toggle="pill" data-bs-target="#v-pills-student-social-media" type="button" role="tab" aria-controls="v-pills-student-social-media" aria-selected="false">

            <i class="fa-solid fa-link"></i>
            <span><?php echo e(__('students.social_links')); ?></span>
        </button>



        <a class="nav-link" type="button" role="tab" aria-selected="false">

            <i class="fa-solid fa-user-pen"></i><span><?php echo e(__('students.edit_student')); ?></span>

        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('view-tabs'); ?>


<div class="tab-pane fade show active" id="pills-student-info" role="tabpanel" aria-labelledby="pills-student-info-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.student_info')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td><?php echo e(__('students.full_name')); ?></td>
                        <td><?php echo e($student->student_name); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.mobile_number')); ?></td>
                        <td><?php echo e($student->phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.birth_address')); ?></td>
                        <td><?php echo e($student->birth_address); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.height')); ?></td>
                        <td><?php echo e($student->height); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.weight')); ?></td>
                        <td><?php echo e($student->weight); ?></td>
                    </tr>

                    <tr>
                        <td><?php echo e(__('students.home_phone')); ?></td>
                        <td><?php echo e($student->home_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.alternative_mobile_number')); ?></td>
                        <td><?php echo e($student->alternative_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.gender')); ?></td>
                        <td><?php echo e($student->gender); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.school_name')); ?></td>
                        <td><?php echo e($student->school_name); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.blood_group')); ?></td>
                        <td><?php echo e($student->blood_group); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.contact_number')); ?></td>
                        <td><?php echo e($student->contact_number); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.dob')); ?></td>
                        <td><?php echo e($student->dob); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.created_by')); ?></td>
                        <td><a class="text-decoration-none" href="<?php echo e(route('viewUser', $student->created_by)); ?>"><?php echo e($student->createdPerson->full_name); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.created_date')); ?></td>
                        <td><?php echo e($student->created_at); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-student-address" role="tabpanel" aria-labelledby="v-pills-student-address-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.student_address')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td><?php echo e(__('students.address')); ?></td>
                        <td><?php echo e($student->address); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.city')); ?></td>
                        <td><?php echo e($student->city); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.state')); ?></td>
                        <td><?php echo e($student->state); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.country')); ?></td>
                        <td><?php echo e($student->country); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.landmark')); ?></td>
                        <td><?php echo e($student->landmark); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-father" role="tabpanel" aria-labelledby="v-pills-father-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.father')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <div class="user-avtar">
                            <?php if($student->father_image !== null): ?>
                            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='<?php echo e(asset("uploads/$student->father_image")); ?>' alt="<?php echo e($student->father_name); ?>">
                            <?php else: ?>
                            <span><?php echo e(ucfirst( $student->father_name[0] )); ?></span>
                            <?php endif; ?>
                        </div>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_name')); ?></td>
                        <td><?php echo e($student->father_name); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_dob')); ?></td>
                        <td><?php echo e($student->father_dob); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_nationality')); ?></td>
                        <td><?php echo e($student->father_nationality); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_national_number')); ?></td>
                        <td><?php echo e($student->father_national_number); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_degree_of_kinship')); ?></td>
                        <td><?php echo e($student->father_degree_of_kinship); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.address')); ?></td>
                        <td><?php echo e($student->father_address); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.city')); ?></td>
                        <td><?php echo e($student->father_city); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.state')); ?></td>
                        <td><?php echo e($student->father_state); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.country')); ?></td>
                        <td><?php echo e($student->father_country); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.landmark')); ?></td>
                        <td><?php echo e($student->father_landmark); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_job')); ?></td>
                        <td><?php echo e($student->father_job); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.marital_status')); ?></td>
                        <td><?php echo e($student->father_marital_status); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_phone')); ?></td>
                        <td><?php echo e($student->father_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_alternative_phone')); ?></td>
                        <td><?php echo e($student->father_alternative_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_email')); ?></td>
                        <td><?php echo e($student->father_email); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.facebook_link')); ?></td>
                        <td><a href=" <?php echo e($student->father_fb_link); ?>"> <?php echo e($student->father_fb_link); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.twitter_link')); ?></td>
                        <td><a href=" <?php echo e($student->father_twitter_link); ?>"> <?php echo e($student->father_twitter_link); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.social_media_link')); ?></td>
                        <td><a href=" <?php echo e($student->father_social_media_1); ?>"> <?php echo e($student->father_social_media_1); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.social_media_link_2')); ?></td>
                        <td><a href=" <?php echo e($student->father_social_media_2); ?>"> <?php echo e($student->father_social_media_2); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_qualification')); ?></td>
                        <td> <?php echo e($student->father_qualification); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.other_qualification')); ?></td>
                        <td> <?php echo e($student->father_qualification_other); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.wedding_date')); ?></td>
                        <td> <?php echo e($student->father_wedding_date); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.interests')); ?></td>
                        <td> <?php echo e($student->father_interests); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_attitudes_towards_father')); ?></td>
                        <td> <?php echo e($student->father_attitudes_towards_parent); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.created_by')); ?></td>
                        <td> <?php echo e($student->father_created_by); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-mother" role="tabpanel" aria-labelledby="v-pills-mother-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.mother')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <div class="user-avtar">
                            <?php if($student->mother_image !== null): ?>
                            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='<?php echo e(asset("uploads/$student->mother_image")); ?>' alt="<?php echo e($student->mother_name); ?>">
                            <?php else: ?>
                            <span><?php echo e(ucfirst( $student->mother_name[0] )); ?></span>
                            <?php endif; ?>
                        </div>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_name')); ?></td>
                        <td><?php echo e($student->mother_name); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_dob')); ?></td>
                        <td><?php echo e($student->mother_dob); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_nationality')); ?></td>
                        <td><?php echo e($student->mother_nationality); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_national_number')); ?></td>
                        <td><?php echo e($student->mother_national_number); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_degree_of_kinship')); ?></td>
                        <td><?php echo e($student->mother_degree_of_kinship); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.address')); ?></td>
                        <td><?php echo e($student->mother_address); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.city')); ?></td>
                        <td><?php echo e($student->mother_city); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.state')); ?></td>
                        <td><?php echo e($student->mother_state); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.country')); ?></td>
                        <td><?php echo e($student->mother_country); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.landmark')); ?></td>
                        <td><?php echo e($student->mother_landmark); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_job')); ?></td>
                        <td><?php echo e($student->mother_job); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.marital_status')); ?></td>
                        <td><?php echo e($student->mother_marital_status); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_phone')); ?></td>
                        <td><?php echo e($student->mother_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_alternative_phone')); ?></td>
                        <td><?php echo e($student->mother_alternative_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_email')); ?></td>
                        <td><?php echo e($student->mother_email); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.facebook_link')); ?></td>
                        <td><a href=" <?php echo e($student->mother_fb_link); ?>"> <?php echo e($student->mother_fb_link); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.twitter_link')); ?></td>
                        <td><a href=" <?php echo e($student->mother_twitter_link); ?>"> <?php echo e($student->mother_twitter_link); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.social_media_link')); ?></td>
                        <td><a href=" <?php echo e($student->mother_social_media_1); ?>"> <?php echo e($student->mother_social_media_1); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.social_media_link_2')); ?></td>
                        <td><a href=" <?php echo e($student->mother_social_media_2); ?>"> <?php echo e($student->mother_social_media_2); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_qualification')); ?></td>
                        <td> <?php echo e($student->mother_qualification); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.other_qualification')); ?></td>
                        <td> <?php echo e($student->mother_qualification_other); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.wedding_date')); ?></td>
                        <td> <?php echo e($student->mother_wedding_date); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.interests')); ?></td>
                        <td> <?php echo e($student->mother_interests); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_attitudes_towards_mother')); ?></td>
                        <td> <?php echo e($student->mother_attitudes_towards_parent); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.created_by')); ?></td>
                        <td> <?php echo e($student->mother_created_by); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php if($student->superior =='Yes'): ?>
<div class="tab-pane fade" id="v-pills-superior" role="tabpanel" aria-labelledby="v-pills-superior-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.superior')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <div class="user-avtar">
                            <?php if($student->superior_image !== null): ?>
                            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;" src='<?php echo e(asset("uploads/$student->superior_image")); ?>' alt="<?php echo e($student->superior_name); ?>">
                            <?php else: ?>
                            <?php if($student->superior_name !==null): ?>
                            <span ><?php echo e(ucfirst( $student->superior_name[0] )); ?></span>
                            <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_name')); ?></td>
                        <td><?php echo e($student->superior_name); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_dob')); ?></td>
                        <td><?php echo e($student->superior_dob); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_nationality')); ?></td>
                        <td><?php echo e($student->superior_nationality); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_national_number')); ?></td>
                        <td><?php echo e($student->superior_national_number); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_degree_of_kinship')); ?></td>
                        <td><?php echo e($student->superior_degree_of_kinship); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.address')); ?></td>
                        <td><?php echo e($student->superior_address); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.city')); ?></td>
                        <td><?php echo e($student->superior_city); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.state')); ?></td>
                        <td><?php echo e($student->superior_state); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.country')); ?></td>
                        <td><?php echo e($student->superior_country); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.landmark')); ?></td>
                        <td><?php echo e($student->superior_landmark); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_dob')); ?></td>
                        <td><?php echo e($student->superior_job); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.marital_status')); ?></td>
                        <td><?php echo e($student->superior_marital_status); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_phone')); ?></td>
                        <td><?php echo e($student->superior_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_alternative_phone')); ?></td>
                        <td><?php echo e($student->superior_alternative_phone); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_email')); ?></td>
                        <td><?php echo e($student->superior_email); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.facebook_link')); ?></td>
                        <td><a href=" <?php echo e($student->superior_fb_link); ?>"> <?php echo e($student->superior_fb_link); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.twitter_link')); ?></td>
                        <td><a href=" <?php echo e($student->superior_twitter_link); ?>"> <?php echo e($student->superior_twitter_link); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.social_media_link')); ?></td>
                        <td><a href=" <?php echo e($student->superior_social_media_1); ?>"> <?php echo e($student->superior_social_media_1); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.social_media_link_2')); ?></td>
                        <td><a href=" <?php echo e($student->superior_social_media_2); ?>"> <?php echo e($student->superior_social_media_2); ?></a></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.parent_qualification')); ?></td>
                        <td> <?php echo e($student->superior_qualification); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.other_qualification')); ?></td>
                        <td> <?php echo e($student->superior_qualification_other); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.wedding_date')); ?></td>
                        <td> <?php echo e($student->superior_wedding_date); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.interests')); ?></td>
                        <td> <?php echo e($student->superior_interests); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_attitudes_towards_superior')); ?></td>
                        <td> <?php echo e($student->superior_attitudes_towards_parent); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.created_by')); ?></td>
                        <td> <?php echo e($student->superior_created_by); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="tab-pane fade" id="v-pills-main-complaint" role="tabpanel" aria-labelledby="v-pills-main-complaint-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.main_problem')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td><?php echo e(__('students.main_problem')); ?></td>
                        <td><?php echo e($student->main_complaint); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.feeling_problem_date')); ?></td>
                        <td><?php echo e($student->problem_start_at); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.time_of_increasing_problem_feeling')); ?></td>
                        <td><?php echo e($student->time_of_increasing_problem_feeling); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.time_of_decreasing_problem_feeling')); ?></td>
                        <td><?php echo e($student->time_of_decreasing_problem_feeling); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.problem_as_child_sideview')); ?></td>
                        <td><?php echo e($student->problem_as_child_view); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.problem_as_father_sideview')); ?></td>
                        <td><?php echo e($student->problem_as_father_view); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.problem_as_mother_sideview')); ?></td>
                        <td><?php echo e($student->problem_as_mother_view); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.problem_reasons')); ?></td>
                        <td><?php echo e($student->problem_reasons); ?></td>
                    </tr>

                </tbody>
            </table>
            
            <h4><?php echo e(__('students.student_diseases')); ?></h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th><?php echo e(__('students.disease')); ?></th>
                    <th><?php echo e(__('students.age_at_inJury')); ?></th>
                    <th><?php echo e(__('students.disease_duration')); ?></th>
                    <th><?php echo e(__('students.disease_strength')); ?></th>
                </thead>
                <tbody>
                    <?php if($student->student_diseases != null): ?>
                    <?php $__currentLoopData = json_decode($student->student_diseases); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student_diseases): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($student_diseases->disease); ?></td>
                        <td><?php echo e($student_diseases->age_at_injury); ?></td>
                        <td><?php echo e($student_diseases->disease_duration); ?></td>
                        <td><?php echo e($student_diseases->disease_degree); ?></td>
                    </tr>


                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>

                </tbody>
            </table>
            
            <h4><?php echo e(__('students.previous_treatment_efforts')); ?>previous treatment efforts</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th><?php echo e(__('students.medical_institution')); ?></th>
                    <th><?php echo e(__('students.provided_service')); ?></th>
                    <th><?php echo e(__('students.provided_service_effects')); ?></th>
                </thead>
                <tbody>
                    <?php if($student->previous_treatment_efforts != null): ?>
                    <?php $__currentLoopData = json_decode($student->previous_treatment_efforts); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $previousTreatmentOfforts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($previousTreatmentOfforts->medical_institution); ?></td>
                        <td><?php echo e($previousTreatmentOfforts->provided_service); ?></td>
                        <td><?php echo e($previousTreatmentOfforts->provided_service_effects); ?></td>
                    </tr>


                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>
                </tbody>
            </table>

            
            <h4><?php echo e(__('students.genetic_diseases')); ?></h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th><?php echo e(__('students.name')); ?></th>
                    <th><?php echo e(__('students.age_at_inJury')); ?></th>
                    <th><?php echo e(__('students.degree_of_kinship')); ?></th>
                    <th><?php echo e(__('students.disease')); ?></th>
                </thead>
                <tbody>

                    <?php if($student->genetic_diseases != null): ?>
                    <?php $__currentLoopData = json_decode($student->genetic_diseases); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genetic_diseases): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($genetic_diseases->name); ?></td>
                        <td><?php echo e($genetic_diseases->age_at_injury); ?></td>
                        <td><?php echo e($genetic_diseases->degree_of_kinship); ?></td>
                        <td><?php echo e($genetic_diseases->disease); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-family-history" role="tabpanel" aria-labelledby="v-pills-family-history-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.family_history')); ?>Family History
            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td><?php echo e(__('students.father')); ?> <?php echo e(__('students.age_on_applying')); ?></td>
                        <td><?php echo e($student->father_age_when_applying); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.father')); ?> <?php echo e(__('students.age_on_student_birth')); ?></td>
                        <td><?php echo e($student->father_age_at_student_birth); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.father')); ?> <?php echo e(__('students.relation_with_child')); ?></td>
                        <td><?php echo e($student->father_relation_with_child); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_attitudes_towards_father')); ?></td>
                        <td><?php echo e($student->child_attitudes_towards_father); ?></td>
                    </tr>

                    <tr>
                        <td><?php echo e(__('students.mother')); ?> <?php echo e(__('students.age_on_applying')); ?></td>
                        <td><?php echo e($student->mother_age_when_applying); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.mother')); ?> <?php echo e(__('students.age_on_student_birth')); ?></td>
                        <td><?php echo e($student->mother_age_at_student_birth); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.mother')); ?> <?php echo e(__('students.relation_with_child')); ?></td>
                        <td><?php echo e($student->mother_relation_with_child); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_attitudes_towards_mother')); ?></td>
                        <td><?php echo e($student->child_attitudes_towards_mother); ?></td>
                    </tr>

                </tbody>
            </table>
            
            <h4 class="mb-3"><?php echo e(__('students.relation_between_parents')); ?></h4>
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td><?php echo e(__('students.relation_between_parents')); ?></td>
                        <td><?php echo e($student->relation_between_parents); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.main_problems_between_parents')); ?></td>
                        <td><?php echo e($student->main_problems_between_parents); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_attitude_towards_family_problems')); ?></td>
                        <td><?php echo e($student->child_attitude_towards_family_problems); ?></td>
                    </tr>

                </tbody>
            </table>
            
            <h4 class="mb-3"><?php echo e(__('students.brothers_and_sisters')); ?></h4>
            <table class="table table-striped user-table mb-4 table-bordered">
                <thead>
                    <th><?php echo e(__('students.name')); ?></th>
                    <th><?php echo e(__('students.dob')); ?></th>
                    <th><?php echo e(__('students.gender')); ?></th>
                    <th><?php echo e(__('students.job')); ?></th>
                    <th><?php echo e(__('students.status')); ?></th>
                    <th><?php echo e(__('students.education_level')); ?></th>
                    <th><?php echo e(__('students.relation_with_student')); ?></th>
                    <th><?php echo e(__('students.student_relation')); ?></th>
                </thead>
                <tbody>


                    <?php if( $student->brothers_and_sisters != null ): ?>
                    <?php $__currentLoopData = json_decode($student->brothers_and_sisters); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brothersAndSisters): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($brothersAndSisters->name); ?></td>
                        <td><?php echo e($brothersAndSisters->dob); ?></td>
                        <td><?php echo e($brothersAndSisters->gender); ?></td>
                        <td><?php echo e($brothersAndSisters->job); ?></td>
                        <td><?php echo e($brothersAndSisters->status); ?></td>
                        <td><?php echo e($brothersAndSisters->education_level); ?></td>
                        <td><?php echo e($brothersAndSisters->relation_with_student); ?></td>
                        <td><?php echo e($brothersAndSisters->student_relation); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    <?php endif; ?>
                    <tr>
                        <td colspan="3"><?php echo e(__('students.brothers_and_sisters_notes')); ?></td>
                        <td colspan="5"><?php echo e($student->brothers_and_sisters_notes); ?></td>
                    </tr>
                </tbody>
            </table>
            
            <?php if($student->are_relatives == 'Yes'): ?>
            <h4 class="mb-3"><?php echo e(__('students.are_relatives')); ?></h4>
            <table class="table table-striped user-table mb-4 table-bordered">
                <thead>
                    <th><?php echo e(__('students.name')); ?></th>
                    <th><?php echo e(__('students.dob')); ?></th>
                    <th><?php echo e(__('students.relationship')); ?></th>
                    <th><?php echo e(__('students.education_level')); ?></th>
                    <th><?php echo e(__('students.relation_with_student')); ?></th>
                    <th><?php echo e(__('students.student_relation')); ?></th>
                </thead>
                <tbody>


                    <?php if( $student->other_relatives != null ): ?>
                    <?php $__currentLoopData = json_decode($student->other_relatives); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherRelatives): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($otherRelatives->name); ?></td>
                        <td><?php echo e($otherRelatives->dob); ?></td>
                        <td><?php echo e($otherRelatives->relationship); ?></td>
                        <td><?php echo e($otherRelatives->education_level); ?></td>
                        <td><?php echo e($otherRelatives->relation_with_student); ?></td>
                        <td><?php echo e($otherRelatives->student_relation); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    <?php endif; ?>
                    <tr>
                        <td colspan="3"><?php echo e(__('students.other_relatives_notes')); ?></td>
                        <td colspan="5"><?php echo e($student->other_relatives_notes); ?></td>
                    </tr>
                </tbody>
            </table>

            <?php endif; ?>
        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-economic_situation" role="tabpanel" aria-labelledby="v-pills-economic_situation-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.economic_situation')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>


                    <tr>
                        <td><?php echo e(__('students.economic_situation')); ?></td>
                        <td><?php echo e($student->economic_situation); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.monthly_average_income')); ?></td>
                        <td><?php echo e($student->monthly_average_income); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.monthly_average_expenses')); ?></td>
                        <td><?php echo e($student->monthly_average_expenses); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.family_economic_problems')); ?></td>
                        <td><?php echo e($student->family_economic_problems); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.family_child_acceptance')); ?></td>
                        <td><?php echo e($student->family_child_acceptance); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.home_type')); ?></td>
                        <td><?php echo e($student->home_type); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.number_persons_in_room')); ?></td>
                        <td><?php echo e($student->no_persons_in_room); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.has_child_individual_room')); ?></td>
                        <td><?php echo e($student->has_child_individual_room); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.number_father_married')); ?></td>
                        <td><?php echo e($student->no_father_married); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.number_mother_married')); ?></td>
                        <td><?php echo e($student->no_mother_married); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.family_divorce_cases')); ?></td>
                        <td><?php echo e($student->family_divorce_cases); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.family_stress_source')); ?></td>
                        <td><?php echo e($student->family_stress_source); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.family_entertainment_source')); ?></td>
                        <td><?php echo e($student->family_entertainment_source); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_interacting_with_family_entertainment_source')); ?></td>
                        <td><?php echo e($student->family_entertainment_source_child_involve); ?></td>
                    </tr>
                </tbody>
            </table>

        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-organic-growth-history" role="tabpanel" aria-labelledby="v-pills-organic-growth-history-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                <?php echo e(__('students.organic_growth_history')); ?>

            </div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>


                    <tr>
                        <td><?php echo e(__('students.mother_diseases_during_pregnancy')); ?></td>
                        <td><?php echo e($student->mother_diseases_during_pregnancy); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.mother_pregnancy_type')); ?></td>
                        <td><?php echo e($student->mother_pregnancy_type); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.disturbances_during_child_birth')); ?></td>
                        <td><?php echo e($student->disturbances_during_childbirth); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.mother_pregnancy_injuries')); ?></td>
                        <td><?php echo e($student->mother_pregnancy_injuries); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_weight_at_birth')); ?></td>
                        <td><?php echo e($student->child_weight_at_birth); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.breastfeeding_type')); ?></td>
                        <td><?php echo e($student->breastfeeding_type); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.breastfeeding_type_note')); ?></td>
                        <td><?php echo e($student->breastfeeding_type_note); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_weaning')); ?></td>
                        <td><?php echo e($student->child_age_on_weaning); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.weaning_problems')); ?></td>
                        <td><?php echo e($student->weaning_problems); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_first_tooth')); ?></td>
                        <td><?php echo e($student->child_age_on_first_tooth); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_sitting')); ?></td>
                        <td><?php echo e($student->child_age_on_sitting); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_crawls')); ?></td>
                        <td><?php echo e($student->child_age_on_crawls); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_stand_up')); ?></td>
                        <td><?php echo e($student->child_age_on_stand_up); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_walking')); ?></td>
                        <td><?php echo e($student->child_age_on_walking); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_first_word')); ?></td>
                        <td><?php echo e($student->child_age_on_first_word); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_open_door')); ?></td>
                        <td><?php echo e($student->child_age_on_open_door); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_use_spoon')); ?></td>
                        <td><?php echo e($student->child_age_on_use_spoon); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.child_age_on_adjust_output_process')); ?></td>
                        <td><?php echo e($student->child_age_on_adjust_output_process); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.does_health_problems')); ?></td>
                        <td><?php echo e($student->does_health_problems); ?></td>
                    </tr>
                    <?php if($student->current_health_problems != null): ?>
                    <tr>

                        <td colspan="12">
                            <table class="table user-table mb-4 table-bordered">
                                <thead>
                                    <th></th>
                                    <th><?php echo e(__('students.current_health_problems')); ?></th>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = json_decode($student->current_health_problems); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currentproblems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->index); ?></td>
                                        <td><?php echo e($currentproblems); ?></td>
                                    </tr>


                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <?php endif; ?>

                    <?php if( $student->does_regularly_medicines != null ): ?>

                    <tr>
                        <td colspan="12">
                            <table class="table user-table mb-4 table-bordered">
                                <thead>
                                    <th><?php echo e(__('students.medicine_name')); ?></th>
                                    <th><?php echo e(__('students.medicine_dose')); ?></th>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = json_decode($student->regularly_medicines); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $regularlymedicines): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($regularlymedicines->medicine); ?></td>
                                        <td><?php echo e($regularlymedicines->dose); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </td>

                    </tr>
                    <?php endif; ?>


                    <?php if( $student->does_complex_disabilities != null ): ?>
                    <tr>
                        <td colspan="12">
                            <table class="table user-table mb-4 table-bordered">
                                <thead>
                                    <th><?php echo e(__('students.does_complex_disabilities')); ?></th>

                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = json_decode($student->does_complex_disabilities); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complexDisabilities): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($complexDisabilities); ?></td>
                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </td>
                    </tr>


                    <?php endif; ?>


                    <tr>
                        <td><?php echo e(__('students.other_complex_disabilities')); ?></td>
                        <td><?php echo e($student->complex_disabilities_other); ?></td>
                    </tr>

                    <?php if( $student->does_prosthetic_devices =='Yes' ): ?>
                    <?php $__currentLoopData = json_decode($student->prosthetic_devices); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prostheticdevices): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(__('students.prosthetic_devices')); ?></td>
                        <td><?php echo e($prostheticdevices); ?></td>


                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    <?php endif; ?>

                </tbody>
            </table>

        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-psychological-and-behavioral-side" role="tabpanel" aria-labelledby="v-pills-psychological-and-behavioral-side-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                Psychological and behavioral side
            </div>
        </div>
        <div class="panel-body p-3">
            <!-- The child's relationship with people -->
            <h4><?php echo e(__('students.prosthetic_devices')); ?>The child's relationship with people</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th> </th>
                    <th><?php echo e(__('students.result')); ?></th>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e(__('students.prosthetic_devices')); ?>personality traits</td>
                        <td><?php echo e($student->personality_traits); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.prosthetic_devices')); ?>personality traits details</td>
                        <td><?php echo e($student->personality_traits_details); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.prosthetic_devices')); ?>relation with friends</td>
                        <td><?php echo e($student->relation_with_friends); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.prosthetic_devices')); ?>relation with relatives</td>
                        <td><?php echo e($student->relation_with_relatives); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.prosthetic_devices')); ?>relation with neighbour</td>
                        <td><?php echo e($student->relation_with_neighbour); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('students.prosthetic_devices')); ?>relation with other gender</td>
                        <td><?php echo e($student->relation_with_other_gender); ?></td>
                    </tr>
                </tbody>
            </table>

            <!-- upbringing style -->
            <h4><?php echo e(__('students.prosthetic_devices')); ?>upbringing style</h4>
            <table class="table  user-table mb-4  table-bordered">
                <tr>
                    <td>upbringing style</td>
                    <td><?php echo e($student->upbringing_style); ?></td>
                </tr>
            </table>

            <!-- reinforcements -->
            <h4>reinforcements</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>#</th>
                    <th>reinforcement</th>

                </thead>
                <tbody>
                    <?php if($student->reinforcements != null): ?>

                    <?php $__currentLoopData = json_decode($student->reinforcements); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reinforcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(($loop->index)+1); ?></td>
                        <td><?php echo e($reinforcement); ?></td>

                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>
                </tbody>
            </table>

            <!-- is punishment -->
            <h4>Punishment</h4>
            <table class="table  user-table mb-4  table-bordered">
                <tr>
                    <td>is punishment</td>
                    <td><?php echo e($student->is_punishment); ?></td>
                </tr>
                <?php if($student->is_punishment=='Yes'): ?>

                <tr>
                    <td>child behavior notes</td>
                    <td><?php echo e($student->child_behavior_notes); ?></td>
                </tr>
                <tr>
                    <td>source of authority</td>
                    <td><?php echo e($student->source_of_authority); ?></td>
                </tr>
                <tr>
                    <td>source of authority notes</td>
                    <td><?php echo e($student->source_of_authority_notes); ?></td>
                </tr>

                <?php endif; ?>
            </table>

            <!--  Child behavior -->
            <h4>Child behavior</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th> </th>
                    <th>result</th>
                </thead>
                <tbody>
                    <tr>
                        <td>crying</td>
                        <td><?php echo e($student->crying); ?></td>
                    </tr>
                    <tr>
                        <td>talkative</td>
                        <td><?php echo e($student->talkative); ?></td>
                    </tr>
                    <tr>
                        <td>lots of movement</td>
                        <td><?php echo e($student->lots_of_movement); ?></td>
                    </tr>
                    <tr>
                        <td>orderly plan</td>
                        <td><?php echo e($student->orderly_plan); ?></td>
                    </tr>
                    <tr>
                        <td>damages</td>
                        <td><?php echo e($student->damages); ?></td>
                    </tr>
                    <tr>
                        <td>find around place</td>
                        <td><?php echo e($student->find_around_place); ?></td>
                    </tr>
                    <tr>
                        <td>grieves with specialist</td>
                        <td><?php echo e($student->grieves_with_specialist); ?></td>
                    </tr>

                    <tr>
                        <td>afraid</td>
                        <td><?php echo e($student->afraid); ?></td>
                    </tr>
                    <tr>
                        <td>enjoys</td>
                        <td><?php echo e($student->enjoys); ?></td>
                    </tr>
                    <tr>
                        <td>runs randomly</td>
                        <td><?php echo e($student->runs_randomly); ?></td>
                    </tr>
                </tbody>
            </table>

            <!-- Neurological and behavioral symptoms -->
            <h4>Neurological and behavioral symptoms</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>behavior</th>
                    <th>result</th>
                    <th>time</th>
                    <th>degree</th>
                </thead>
                <tbody>
                    <tr>
                        <td>outbursts of anger</td>
                        <td><?php echo e($student->outbursts_of_anger); ?></td>
                        <td><?php echo e($student->outbursts_of_anger_time); ?></td>
                        <td><?php echo e($student->outbursts_of_anger_degree); ?></td>
                    </tr>


                    <tr>
                        <td>finger sucking</td>
                        <td><?php echo e($student->finger_sucking); ?></td>
                        <td><?php echo e($student->finger_sucking_time); ?></td>
                        <td><?php echo e($student->finger_sucking_degree); ?></td>
                    </tr>

                    <tr>
                        <td>wetting bed</td>
                        <td><?php echo e($student->wetting_bed); ?></td>
                        <td><?php echo e($student->wetting_bed_time); ?></td>
                        <td><?php echo e($student->wetting_bed_degree); ?></td>
                    </tr>

                    <tr>
                        <td>night screams of terror</td>
                        <td><?php echo e($student->night_screams_of_terror); ?></td>
                        <td><?php echo e($student->night_screams_of_terror_time); ?></td>
                        <td><?php echo e($student->night_screams_of_terror_degree); ?></td>
                    </tr>


                    <tr>
                        <td>sleep walking</td>
                        <td><?php echo e($student->sleep_walking); ?></td>
                        <td><?php echo e($student->sleep_walking_time); ?></td>
                        <td><?php echo e($student->sleep_walking_degree); ?></td>
                    </tr>
                    <tr>
                        <td>excessive fears</td>
                        <td><?php echo e($student->excessive_fears); ?></td>
                        <td><?php echo e($student->excessive_fears_time); ?></td>
                        <td><?php echo e($student->excessive_fears_degree); ?></td>
                    </tr>
                    <tr>
                        <td>nervous crises</td>
                        <td><?php echo e($student->nervous_crises); ?></td>
                        <td><?php echo e($student->nervous_crises_time); ?></td>
                        <td><?php echo e($student->nervous_crises_degree); ?></td>
                    </tr>
                    <tr>
                        <td>cramps</td>
                        <td><?php echo e($student->cramps); ?></td>
                        <td><?php echo e($student->cramps_time); ?></td>
                        <td><?php echo e($student->cramps_degree); ?></td>
                    </tr>
                    <tr>
                        <td>biting nails</td>
                        <td><?php echo e($student->biting_nails); ?></td>
                        <td><?php echo e($student->biting_nails_time); ?></td>
                        <td><?php echo e($student->biting_nails_degree); ?></td>
                    </tr>
                    <tr>
                        <td>smash clothes</td>
                        <td><?php echo e($student->smash_clothes); ?></td>
                        <td><?php echo e($student->smash_clothes_time); ?></td>
                        <td><?php echo e($student->smash_clothes_degree); ?></td>
                    </tr>
                    <tr>
                        <td>stereotyped movements</td>
                        <td><?php echo e($student->stereotyped_movements); ?></td>
                        <td><?php echo e($student->stereotyped_movements_time); ?></td>
                        <td><?php echo e($student->stereotyped_movements_degree); ?></td>
                    </tr>
                    <tr>
                        <td>baby gets nervous from loud noises</td>
                        <td><?php echo e($student->baby_gets_nervous_from_loud_noises); ?></td>
                        <td><?php echo e($student->baby_gets_nervous_from_loud_noises_time); ?></td>
                        <td><?php echo e($student->baby_gets_nervous_from_loud_noises_degree); ?></td>
                    </tr>
                    <tr>
                        <td>baby gets nervous from bright lights</td>
                        <td><?php echo e($student->baby_gets_nervous_from_bright_lights); ?></td>
                        <td><?php echo e($student->baby_gets_nervous_from_bright_lights_time); ?></td>
                        <td><?php echo e($student->baby_gets_nervous_from_bright_lights_degree); ?></td>
                    </tr>
                    <tr>
                        <td>sexual behaviors</td>
                        <td><?php echo e($student->sexual_behaviors); ?></td>
                        <td><?php echo e($student->sexual_behaviors_time); ?></td>
                        <td><?php echo e($student->sexual_behaviors_degree); ?></td>
                    </tr>
                    <tr>
                        <td>epileptic seizures</td>
                        <td><?php echo e($student->epileptic_seizures); ?></td>
                        <td><?php echo e($student->epileptic_seizures_time); ?></td>
                        <td><?php echo e($student->epileptic_seizures_degree); ?></td>
                    </tr>
                </tbody>
            </table>

            <!-- Child's social problems -->
            <h4>Child's social problems</h4>
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th>behavior</th>
                    <th>result</th>
                    <th>description</th>
                </thead>
                <tbody>
                    <tr>
                        <td>difficulty interacting with peers</td>
                        <td><?php echo e($student->difficulty_interacting_with_peers); ?></td>
                        <td><?php echo e($student->difficulty_interacting_with_peers_desc); ?></td>
                    </tr>

                    <tr>
                        <td>extra activity</td>
                        <td><?php echo e($student->extra_activity); ?></td>
                        <td><?php echo e($student->extra_activity_desc); ?></td>
                    </tr>

                    <tr>
                        <td>make fun of others</td>
                        <td><?php echo e($student->make_fun_of_others); ?></td>
                        <td><?php echo e($student->make_fun_of_others_desc); ?></td>
                    </tr>
                    <tr>
                        <td>can not wait</td>
                        <td><?php echo e($student->can_not_wait); ?></td>
                        <td><?php echo e($student->can_not_wait_dec); ?></td>
                    </tr>

                    <tr>
                        <td>curses and says inappropriate words</td>
                        <td><?php echo e($student->curses_and_says_inappropriate_words); ?></td>
                        <td><?php echo e($student->curses_and_says_inappropriate_words_dec); ?></td>
                    </tr>
                    <tr>
                        <td>acts inappropriately</td>
                        <td><?php echo e($student->acts_inappropriately); ?></td>
                        <td><?php echo e($student->acts_inappropriately_dec); ?></td>
                    </tr>
                    <tr>
                        <td>very shy</td>
                        <td><?php echo e($student->very_shy); ?></td>
                        <td><?php echo e($student->very_shy_dec); ?></td>
                    </tr>
                    <tr>
                        <td>speaks low voice</td>
                        <td><?php echo e($student->speaks_low_voice); ?></td>
                        <td><?php echo e($student->speaks_low_voice_dec); ?></td>
                    </tr>
                    <tr>
                        <td>not defend himself</td>
                        <td><?php echo e($student->not_defend_himself); ?></td>
                        <td><?php echo e($student->not_defend_himself_dec); ?></td>
                    </tr>
                    <tr>
                        <td>afraid of animals</td>
                        <td><?php echo e($student->afraid_of_animals); ?></td>
                        <td><?php echo e($student->afraid_of_animals_dec); ?></td>
                    </tr>
                    <tr>
                        <td>hesitant and confused</td>
                        <td><?php echo e($student->hesitant_and_confused); ?></td>
                        <td><?php echo e($student->hesitant_and_confused_dec); ?></td>
                    </tr>
                    <tr>
                        <td>feeling powerless and lacking in self confidence</td>
                        <td><?php echo e($student->feeling_powerless_and_lacking_in_self_confidence); ?></td>
                        <td><?php echo e($student->feeling_powerless_and_lacking_in_self_confidence_dec); ?></td>
                    </tr>
                    <tr>
                        <td>feeling tense and refuses to hug</td>
                        <td><?php echo e($student->feeling_tense_and_refuses_to_hug); ?></td>
                        <td><?php echo e($student->feeling_tense_and_refuses_to_hug_dec); ?></td>
                    </tr>
                </tbody>
            </table>


            <!-- other social problems -->
            <table class="table table-striped user-table mb-4  table-bordered">
                <tr>
                    <td>other social problems</td>
                    <td><?php echo e($student->other_social_problems); ?></td>
                </tr>
            </table>


            <table class="table  user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>last psychological examination name</td>
                        <td><?php echo e($student->last_psychological_examination_name); ?></td>
                    </tr>
                    <tr>
                        <td>last psychological examination date</td>
                        <td><?php echo e($student->last_psychological_examination_date); ?></td>
                    </tr>

                </tbody>
            </table>

            <!-- previous mental disorders -->
            <h4>previous mental disorders</h4>
            <div class="table-responsive">
                <table class="table table-striped user-table mb-4  table-bordered">

                    <thead>
                        <th>N</th>
                        <th>name</th>
                        <th>date</th>
                        <th>reason</th>
                        <th>who recommended it</th>
                        <th>explan</th>
                        <th>recommendations</th>



                    </thead>
                    <tbody>
                        <tr>
                            <th>first</th>
                            <td><?php echo e($student->first_intelligence_and_ability_test_name); ?></td>
                            <td><?php echo e($student->first_intelligence_and_ability_test_date); ?></td>
                            <td><?php echo e($student->first_intelligence_and_ability_test_reason); ?></td>
                            <td><?php echo e($student->first_intelligence_and_ability_test_who_recommended_it); ?></td>
                            <td><?php echo e($student->first_intelligence_and_ability_test_result); ?></td>
                            <td><?php echo e($student->first_intelligence_and_ability_test_result); ?></td>
                        </tr>

                        <tr>
                            <th>second</th>
                            <td><?php echo e($student->second_intelligence_and_ability_test_name); ?></td>
                            <td><?php echo e($student->second_intelligence_and_ability_test_date); ?></td>
                            <td><?php echo e($student->second_intelligence_and_ability_test_reason); ?></td>
                            <td><?php echo e($student->second_intelligence_and_ability_test_who_recommended_it); ?></td>
                            <td><?php echo e($student->second_intelligence_and_ability_test_result); ?></td>
                            <td><?php echo e($student->second_intelligence_and_ability_test_result); ?></td>
                        </tr>
                        <tr>
                            <th>third</th>
                            <td><?php echo e($student->third_intelligence_and_ability_test_name); ?></td>
                            <td><?php echo e($student->third_intelligence_and_ability_test_date); ?></td>
                            <td><?php echo e($student->third_intelligence_and_ability_test_reason); ?></td>
                            <td><?php echo e($student->third_intelligence_and_ability_test_who_recommended_it); ?></td>
                            <td><?php echo e($student->third_intelligence_and_ability_test_result); ?></td>
                            <td><?php echo e($student->third_intelligence_and_ability_test_result); ?></td>
                        </tr>
                        <tr>
                            <th> fourth</th>
                            <td><?php echo e($student->fourth_intelligence_and_ability_test_name); ?></td>
                            <td><?php echo e($student->fourth_intelligence_and_ability_test_date); ?></td>
                            <td><?php echo e($student->fourth_intelligence_and_ability_test_reason); ?></td>
                            <td><?php echo e($student->fourth_intelligence_and_ability_test_who_recommended_it); ?></td>
                            <td><?php echo e($student->fourth_intelligence_and_ability_test_result); ?></td>
                            <td><?php echo e($student->fourth_intelligence_and_ability_test_result); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Independent aspect -->
            <h4>Independent aspect</h4>
            <table class="table table-striped user-table mb-4  table-bordered">

                <thead>
                    <th>behavior</th>
                    <th>result</th>
                </thead>
                <tbody>
                    <tr>
                        <td>eats alone without help</td>
                        <td><?php echo e($student->eats_alone_without_help); ?></td>
                    </tr>
                    <tr>
                        <td>gets dressed without help</td>
                        <td><?php echo e($student->gets_dressed_without_help); ?></td>
                    </tr>
                    <tr>
                        <td>asking to go to the bathroom</td>
                        <td><?php echo e($student->asking_to_go_to_the_bathroom); ?></td>
                    </tr>
                    <tr>
                        <td>takes care of himself in bathroom</td>
                        <td><?php echo e($student->takes_care_of_himself_in_bathroom); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="tab-pane fade" id="v-pills-Linguistic-side" role="tabpanel" aria-labelledby="v-pills-Linguistic-side-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">
                Linguistic side
            </div>
        </div>
        <div class="panel-body p-3">

            <!--     Linguistic side -->
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th> behavior </th>
                    <th>result</th>
                </thead>
                <tbody>
                    <tr>
                        <td>pay attention to sounds</td>
                        <td><?php echo e($student->pay_attention_to_sounds); ?></td>
                    </tr>
                    <tr>
                        <td>distinguish mother and father voice</td>
                        <td><?php echo e($student->distinguish_mother_and_father_voice); ?></td>
                    </tr>
                    <tr>
                        <td>distinguish family members voice</td>
                        <td><?php echo e($student->distinguish_family_members_voice); ?></td>
                    </tr>
                    <tr>
                        <td>using audio clips</td>
                        <td><?php echo e($student->using_audio_clips); ?></td>
                    </tr>
                    <tr>
                        <td>pronounces word understandable</td>
                        <td><?php echo e($student->pronounces_word_understandable); ?></td>
                    </tr>
                    <tr>
                        <td>turns around when he hears his name</td>
                        <td><?php echo e($student->turns_around_when_he_hears_his_name); ?></td>
                    </tr>
                    <tr>
                        <td>looking the person speaking during conversation</td>
                        <td><?php echo e($student->looking_the_person_speaking_during_conversation); ?></td>
                    </tr>
                    <tr>
                        <td>uses two words sentence</td>
                        <td><?php echo e($student->uses_two_words_sentence); ?></td>
                    </tr>
                    <tr>
                        <td>needs encouragement to speak</td>
                        <td><?php echo e($student->needs_encouragement_to_speak); ?></td>
                    </tr>
                    <tr>
                        <td>uses expressive language to express his needs</td>
                        <td><?php echo e($student->uses_expressive_language_to_express_his_needs); ?></td>
                    </tr>
                    <tr>
                        <td>stutters while speaking</td>
                        <td><?php echo e($student->stutters_while_speaking); ?></td>
                    </tr>
                    <tr>
                        <td>remove letters from words</td>
                        <td><?php echo e($student->remove_letters_from_words); ?></td>
                    </tr>
                    <tr>
                        <td>add letters to words</td>
                        <td><?php echo e($student->add_letters_to_words); ?></td>
                    </tr>
                    <tr>
                        <td>turns some letters in word</td>
                        <td><?php echo e($student->turns_some_letters_in_word); ?></td>
                    </tr>
                    <tr>
                        <td>changes some letters when saying word</td>
                        <td><?php echo e($student->changes_some_letters_when_saying_word); ?></td>
                    </tr>
                    <tr>
                        <td>speaks but the words are distorted and incomprehensible</td>
                        <td><?php echo e($student->speaks_but_the_words_are_distorted_and_incomprehensible); ?></td>
                    </tr>
                    <tr>
                        <td>understands what is asked of him</td>
                        <td><?php echo e($student->understands_what_is_asked_of_him); ?></td>
                    </tr>

                </tbody>
            </table>
            <!-- Child linguistic problems -->
            <table class="table table-striped user-table mb-4  table-bordered">
                <thead>
                    <th> </th>
                    <th>result</th>
                </thead>
                <tbody>
                    <tr>
                        <td>language level</td>
                        <td><?php echo e($student->language_level); ?></td>
                    </tr>
                    <tr>
                        <td>level of expression of his needs linguistically</td>
                        <td><?php echo e($student->level_of_expression_of_his_needs_linguistically); ?></td>
                    </tr>
                    <tr>
                        <td>level of coherence of ideas</td>
                        <td><?php echo e($student->level_of_coherence_of_ideas); ?></td>
                    </tr>
                    <tr>
                        <td>speed level</td>
                        <td><?php echo e($student->speed_level); ?></td>
                    </tr>
                    <tr>
                        <td>response</td>
                        <td><?php echo e($student->response); ?></td>
                    </tr>

                </tbody>
            </table>

        </div>
    </div>
</div>



<div class="tab-pane fade" id="v-pills-student-social-media" role="tabpanel" aria-labelledby="v-pills-student-social-media-tab">
    <div class="panel panel-default">
        <div class="panel-head">
            <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h2 text-custome">Student Social Media</div>
        </div>
        <div class="panel-body p-3">
            <table class="table table-striped user-table mb-4 table-bordered">
                <tbody>
                    <tr>
                        <td>FaceBook</td>
                        <td><a class="text-decoration-none" href="<?php echo e($student->fb_link); ?>"><?php echo e($student->fb_link); ?></a>
                        </td>
                    </tr>
                    <tr>
                        <td>Twitter</td>
                        <td>
                            <a class="text-decoration-none" href="<?php echo e($student->twitter_link); ?>">
                                <?php echo e($student->twitter_link); ?>

                            </a>
                        </td>
                    </tr>
                    <tr>
                        <td>S.M Link</td>
                        <td><a class="text-decoration-none" href="<?php echo e($student->social_media_1); ?>"><?php echo e($student->social_media_1); ?></a></td>
                    </tr>
                    <tr>
                        <td>S.M Link</td>
                        <td><a class="text-decoration-none" href="<?php echo e($student->social_media_2); ?>"><?php echo e($student->social_media_2); ?></a></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    var superior = <?php echo json_encode($student->superior); ?>;
</script>

<script src="<?php echo e(asset('js/print.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\assignments\resources\views/students/view.blade.php ENDPATH**/ ?>