

<?php $__env->startSection('title'); ?>
    All Business Locations
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    <?php echo e(__('business_location.business_locations')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li><?php echo e(__('business_location.business_locations')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
<?php if(Auth::user()->role == "super_admin"): ?>
<a href="<?php echo e(route('createBusinessLocation')); ?>" class="btn btn-outline-primary btn-sm me-2">
    <i class="fa-solid fa-plus me-2"></i><?php echo e(__('business_location.new_business_locations')); ?>

</a>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col"><?php echo e(__('business_location.logo')); ?></th>
    <th scope="col"><?php echo e(__('business_location.business_name')); ?></th>
    <th scope="col"><?php echo e(__('business_location.address')); ?></th>
    <th scope="col"><?php echo e(__('business_location.owner_name')); ?></th>
    <th scope="col"><?php echo e(__('business_location.created_by')); ?></th>
    <th scope="col"><?php echo e(__('business_location.status')); ?></th>
    <th scope="col"><?php echo e(__('business_location.actions')); ?></th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business_location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row" class="imageTitle">
                <?php if($business_location->image !== null && $business_location->image !== ''): ?>
                    <img class="image-fload" width="100px" height="100px"
                        src='<?php echo e(asset("uploads/$business_location->image")); ?>'
                        alt="<?php echo e($business_location->business_name); ?>">
                <?php else: ?>
                    <h2> <?php echo e($business_location->business_name[0]); ?></h2>
                <?php endif; ?>
            </th>
            <td class="Zindex">
                <h6 class="col-4"><?php echo e(__('business_location.name')); ?></h6>
                <a class="text-decoration-none col-8" href="<?php echo e(route('viewBusinessLocation', $business_location->id)); ?>">
                    <p class="text-custome m-0 "><?php echo e($business_location->business_name); ?></p>
                </a>
                <h6 class="col-4"><?php echo e(__('business_location.email')); ?></h6>
                <p class="m-0  col-8"><?php echo e($business_location->email); ?></p>
                <h6 class="col-4"><?php echo e(__('business_location.phone')); ?></h6>
                <p class="m-0  col-8"><?php echo e($business_location->phone); ?></p>
                <h6 class="col-4"><?php echo e(__('business_location.alternative_phone')); ?></h6>
                <p class="m-0  col-8"><?php echo e($business_location->alternative_phone); ?></p>
            </td>
            <td class="Zindex">
                <h6 class="col-4"><?php echo e(__('business_location.address')); ?></h6>
                <p class="m-0  col-8"><?php echo e($business_location->address); ?></p>
            </td>
       
            <td class="Zindex">
                <h6 class="col-4"><?php echo e(__('business_location.owner_name')); ?></h6>
                <a class="text-decoration-none col-8" href="<?php echo e(route('viewUser', $business_location->owner_id)); ?>">
                    <p class="m-0 "><?php echo e($business_location->owner->user_name); ?></p>
                </a>
            </td>
            <td class="Zindex">
                <h6 class="col-4"><?php echo e(__('business_location.created_by')); ?></h6>
                <a class="text-decoration-none  col-8"  href="<?php echo e(route('viewUser', $business_location->created_by)); ?>">
                    <p class="m-0 "><?php echo e($business_location->createdPerson->user_name); ?></p>
                </a>
            </td>
            <td class="Zindex">

                <?php if($business_location->is_active == 'Active'): ?>
                    <button class="btn btn-sm btn-success"><?php echo e(__('business_location.active')); ?></button>
                <?php else: ?>
                    <button class="btn btn-sm btn-danger"><?php echo e(__('business_location.inactive')); ?></button>
                <?php endif; ?>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('viewBusinessLocation', $business_location->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                <?php echo e(__('business_location.view')); ?>

                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('editBusinessLocation', $business_location->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                <?php echo e(__('business_location.edit')); ?>

                            </a>
                        </li>
                        <?php if(Auth::user()->role == "super_admin"): ?>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('deleteBusinessLocation', $business_location->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                <?php echo e(__('business_location.delete')); ?>

                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Bahaaaaa\assignments\resources\views/business-locations/list.blade.php ENDPATH**/ ?>