

<?php $__env->startSection('title'); ?>
Student Assignment
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('inc.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section id="setting">
    <div class="container">
        <form method="POST" action="<?php echo e(route('createStudentAssignment')); ?>" id="FormTabs" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="bg-white overflow-auto  shadow-lg  rounded-lg">
                <h1 class="text-center text-spec py-5 bg-light border-bottom"><?php echo e(__('students.setting_your_quiz')); ?></h1>
                <div class="p-4">

                    <div class="row mb-3 border-bottom text-capitalize">
                        <?php if($student->student_name !=null): ?>
                        <div class="col-md-6">
                            <h5><?php echo e(__('students.student_name_')); ?><span class="text-muted fs-6"><?php echo e($student->student_name); ?></span></h5>
                        </div>
                        <?php endif; ?>
                        <?php if($student->dob !=null): ?>
                        <div class="col-md-6">
                            <h5><?php echo e(__('students.date_of_birth_')); ?><span class="text-muted fs-6"><?php echo e($student->dob); ?></span></h5>
                        </div>
                        <?php endif; ?>
                        <?php if($student->dob !=null): ?>
                        <div class="col-md-6">
                            <h5><?php echo e(__('students.age_:')); ?><span class="text-muted fs-6">
                                    <?php echo e(\Carbon\Carbon::parse($student->dob)->diff(\Carbon\Carbon::now())->format('%y years, %m months and %d days')); ?>

                                </span>
                            </h5>
                        </div>
                        <?php endif; ?>
                        <?php if($student->nationality !=null): ?>
                        <div class="col-md-6">
                            <h5><?php echo e(__('students.nationality_:')); ?><span class="text-muted fs-6"><?php echo e($student->nationality); ?></span></h5>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">

                        <label for="Assignment" class="text-spec"><?php echo e(__('students.assignment_title')); ?></label>
                        <select id="Assignment" class="form-control" name="assignment">
                            <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($assignment->id); ?>|<?php echo e($assignment->assignment_shortname); ?>"><?php echo e($assignment->assignment_title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group my-3">

                        <label for="informationAssignment" class="text-spec">
                            <?php echo e(__('students.based_on_the_information_which_has_been_taken_from')); ?>


                        </label>
                        <select id="informationAssignment" multiple class="form-control" name="assignmentInformation[]" aria-label="multiple select example" required>
                            <option value="Father"><?php echo e(__('students.father')); ?></option>
                            <option value="Mother"><?php echo e(__('students.mother')); ?></option>
                            <option value="Superior"><?php echo e(__('students.superior')); ?></option>
                            <option value="Teacher"><?php echo e(__('students.teacher')); ?></option>
                            <option value="Trainer"><?php echo e(__('students.trainer')); ?></option>
                            <option value="Notes"><?php echo e(__('students.notes')); ?></option>
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="hidden" class="form-control" name="studentId" value="<?php echo e($student->id); ?>">
                    </div>
                    <button id="startBtn" type="submit" class="bg-gradient btn float-right py-2 px-4 bg-spec rounded-pill text-white my-4"><?php echo e(__('students.start')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Bahaaaaa\assignments\resources\views/students/take_assignment.blade.php ENDPATH**/ ?>