

<?php $__env->startSection('title'); ?>
    All Users
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    Users
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li>Users</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createUser')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New User
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col">Image</th>
    <th scope="col">User</th>
    <th scope="col">Nationality</th>
    <th scope="col">Gender</th>
    <th scope="col">Allow Login</th>
    <th scope="col">Is Active</th>
    <th scope="col">Business Location</th>
    <th scope="col">Actions</th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td scope="row">
                <?php if($user->image !== null): ?>
                    <img class="image-fload" width="100px" height="100px" src='<?php echo e(asset("uploads/$user->image")); ?>'
                        alt="<?php echo e($user->full_name); ?>">
                <?php else: ?>
                    No User Image
                <?php endif; ?>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewUser', $user->id)); ?>">
                    <p class="text-primary m-0 px-3"><?php echo e($user->full_name); ?></p>
                </a>
                <p class="m-0 px-3"><?php echo e($user->email); ?></p>
                <p class="m-0 px-3"><?php echo e($user->phone); ?></p>
            </td>
            <td>
                <p class="m-0 px-3"><?php echo e($user->nationality); ?></p>
            </td>
            <td>
                <p class="m-0 px-3"><?php echo e($user->gender); ?></p>
            </td>
            <td>
                <?php if($user->allow_login == 'Allowable'): ?>
                    <p class="m-0 px-3 text-success">Allowable</p>
                <?php else: ?>
                    <p class="m-0 px-3 text-danger">Not Allowable</p>
                <?php endif; ?>
            </td>
            <td>
                <?php if($user->is_active == 'Active'): ?>
                    <p class="m-0 px-3 text-success">Active</p>
                <?php else: ?>
                    <p class="m-0 px-3 text-danger">InActive</p>
                <?php endif; ?>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewBusinessLocation', $user->business_id)); ?>">
                    <p class="m-0 px-3"><?php echo e($user->business_location->business_name); ?></p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('viewUser', $user->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-primary"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('editUser', $user->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('deleteUser', $user->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/users/list.blade.php ENDPATH**/ ?>