

<?php $__env->startSection('title'); ?>
    <?php echo e(__('users.list_users')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
<?php echo e(__('users.users')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li><?php echo e(__('users.users')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createUser')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i><?php echo e(__('users.new_user')); ?>

    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col"><?php echo e(__('users.new_user')); ?></th>
    <th scope="col"><?php echo e(__('users.user')); ?></th>
    <th scope="col"><?php echo e(__('users.nationality')); ?></th>
    <th scope="col"><?php echo e(__('users.gender')); ?></th>
    <th scope="col"><?php echo e(__('users.business_location')); ?></th>
    
    <th scope="col"><?php echo e(__('users.is_active')); ?></th>
    <th scope="col"><?php echo e(__('users.actions')); ?></th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td scope="row" class="imageTitle">
                <?php if($user->image !== null && $user->image !== ''): ?>
                    <img class="image-fload" width="100px" height="100px" src='<?php echo e(asset("uploads/$user->image")); ?>'
                        alt="<?php echo e($user->full_name); ?>">
                <?php else: ?>
                    <h2> <?php echo e($user->full_name[0]); ?></h2>
                <?php endif; ?>
            </td>
            <td class="Zindex Zindex1">
                <h6 class="col-5"><?php echo e(__('users.name')); ?></h6>
                <p class="m-0  col-7">
                    <a class="text-decoration-none text-custome " href="<?php echo e(route('viewUser', $user->id)); ?>">
                        <?php echo e($user->full_name); ?>

                    </a>
                </p>
                <h6 class="col-5"><?php echo e(__('users.email')); ?></h6>
                <p class="m-0  col-7"><?php echo e($user->email); ?></p>
                <h6 class="col-5"><?php echo e(__('users.phone')); ?></h6>
                <p class="m-0  col-7"><?php echo e($user->phone); ?></p>

            </td>
            <td class="Zindex">
                <h6 class="col-5"><?php echo e(__('users.nationality')); ?></h6>
                <p class="m-0  col-7"><?php echo e($user->nationality); ?></p>

            </td>
            <td class="Zindex">
                <h6 class="col-5"><?php echo e(__('users.gender')); ?></h6>
                <p class="m-0  col-7"><?php echo e($user->gender); ?></p>

            </td>

            <td class="Zindex">
                <h6 class="col-5"><?php echo e(__('users.business_location')); ?></h6>
                <a class="text-decoration-none m-0 col-7" href="<?php echo e(route('viewBusinessLocation', $user->business_id)); ?>">
                    <p class="m-0 px-3"><?php echo e($user->business_location->business_name); ?></p>
                </a>
            </td>
            <td class="Zindex">
                <h6 class="col-5"><?php echo e(__('users.status')); ?></h6>
                
                <?php if($user->is_active == 'Active'): ?>
                    <p class="text-success m-0  col-7"><?php echo e(__('users.active')); ?></p>
                <?php else: ?>
                    <p class="text-danger m-0  col-7"><?php echo e(__('users.in_active')); ?></p>
                <?php endif; ?>
            </td>

            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('viewUser', $user->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                <?php echo e(__('users.view')); ?>

                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('editUser', $user->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                <?php echo e(__('users.edit')); ?>

                            </a>
                        </li>
                        <?php if(Auth::user()->role == 'super_admin'): ?>
                            <li>
                                <a class="dropdown-item opacity-75 " href="<?php echo e(route('deleteUser', $user->id)); ?>">
                                    <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                    <?php echo e(__('users.delete')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\assignments\resources\views/users/list.blade.php ENDPATH**/ ?>