

<?php $__env->startSection('title'); ?>
    View Trainer
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-title'); ?>
    View Trainer - <?php echo e($trainer->users->full_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-navigation'); ?>
    <li><a class="text-decoration-none" href="<?php echo e(route('allTrainers')); ?>">List Trainers </a></li>
    <li>View Trainer</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('view-panel'); ?>
    <div class="user-avtar">
        <?php if($trainer->users->image !== null): ?>
            <?php
                $image = $trainer->users->image;
            ?>
            <img class="img-thumbnail" style="width: 165px; height: 165px; border-radius: 100px;"
                src='<?php echo e(asset("uploads/$image")); ?>' alt="<?php echo e($trainer->users->full_name); ?>">
        <?php else: ?>
            <span><?php echo e(ucfirst($trainer->users->full_name[0])); ?></span>
        <?php endif; ?>
    </div>
    <div class="user-details text-center pt-3">
        <h3><?php echo e($trainer->users->full_name); ?></h3>
        <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">

            <button class="nav-link active" id="v-pills-trainer-info-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-trainer-info" type="button" role="tab" aria-controls="v-pills-trainer-info"
                aria-selected="true">
                <i class="fa-solid fa-circle-exclamation"></i><span>Trainer Info</span>
            </button>
            <button class="nav-link" id="v-pills-trainer-address-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-trainer-address" type="button" role="tab"
                aria-controls="v-pills-trainer-address" aria-selected="false"><i
                    class="fa-solid fa-address-book"></i><span>Address Info</span></button>
            <button class="nav-link" id="v-pills-trainer-social-media-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-trainer-social-media" type="button" role="tab"
                aria-controls="v-pills-trainer-social-media" aria-selected="false"><i
                    class="fa-solid fa-link"></i><span>Social Links</span></button>
            <button class="nav-link" id="v-pills-trainer-education-info-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-trainer-education-info" type="button" role="tab"
                aria-controls="v-pills-trainer-education-info" aria-selected="false"><i
                    class="fa-solid fa-university"></i><span>Education Info</span></button>
            <button class="nav-link" id="v-pills-trainer-experience-info-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-trainer-experience-info" type="button" role="tab"
                aria-controls="v-pills-trainer-experience-info" aria-selected="false"><i
                    class="fa-solid fa-graduation-cap"></i><span>Experience Info</span></button>
            <a class="nav-link" type="button" role="tab" aria-selected="false"
                href="<?php echo e(route('editTrainer', $trainer->id)); ?>"><i class="fa-solid fa-user-pen"></i><span>Edit
                    Trainer</span></a>
            
            <button class="nav-link" id="v-pills-user-sendwhatsapp-tab" data-bs-toggle="pill"
                data-bs-target="#v-pills-user-sendwhatsapp" type="button" role="tab"
                aria-controls="v-pills-user-sendwhatsapp" aria-selected="false"><i class="fa-solid fa-envelope"></i>
                <span>Send WhatsApp</span></button>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('view-tabs'); ?>
    
    <div class="tab-pane fade show active" id="v-pills-trainer-info" role="tabpanel"
        aria-labelledby="v-pills-trainer-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Trainer Info</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>User Name</td>
                            <td><?php echo e($trainer->users->user_name); ?></td>
                        </tr>
                        <tr>
                            <td>Full Name</td>
                            <td><?php echo e($trainer->users->full_name); ?></td>
                        </tr>
                        <tr>
                            <td>Email Address</td>
                            <td><?php echo e($trainer->users->email); ?></td>
                        </tr>
                        <tr>
                            <td>Mobile Number</td>
                            <td><?php echo e($trainer->users->phone); ?></td>
                        </tr>
                        <tr>
                            <td>Alternative Mobile Number</td>
                            <td><?php echo e($trainer->users->alternative_phone); ?></td>
                        </tr>
                        <tr>
                            <td>Date of Birth</td>
                            <td><?php echo e($trainer->users->dob); ?></td>
                        </tr>
                        <tr>
                            <td>Gender</td>
                            <td><?php echo e($trainer->users->gender); ?></td>
                        </tr>
                        <tr>
                            <td>Blood Group</td>
                            <td><?php echo e($trainer->users->blood_group); ?></td>
                        </tr>
                        
                        <tr>
                            <td>Nationality</td>
                            <td><?php echo e($trainer->users->nationality); ?></td>
                        </tr>
                        <tr>
                            <td>National Number</td>
                            <td><?php echo e($trainer->users->national_number); ?></td>
                        </tr>
                        <tr>
                            <td>Marital Status</td>
                            <td><?php echo e($trainer->users->marital_status); ?></td>
                        </tr>
                        <tr>
                            <td>Business Location</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e(route('viewBusinessLocation', $trainer->business_id)); ?>">
                                    <p><?php echo e($trainer->businessLocation->business_name); ?></p>
                                </a></td>
                        </tr>
                        <tr>
                            <td>Join Job Date</td>
                            <td><?php echo e($trainer->join_job_date); ?></td>
                        </tr>
                        <tr>
                            <td>Status</td>
                            <td>
                                <?php if($trainer->users->is_active == 'Active'): ?>
                                    <span class="text-success"><?php echo e($trainer->users->is_active); ?></span>
                                    
                                <?php else: ?>
                                    <span class="text-danger"><?php echo e($trainer->users->is_active); ?></span>
                                    
                                <?php endif; ?>
                            </td>
                        </tr>
                        
                        <tr>
                            <td>Created By</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e(route('viewUser', $trainer->created_by)); ?>"><?php echo e($trainer->createdBy->full_name); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-trainer-address" role="tabpanel" aria-labelledby="v-pills-trainer-address-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">User Address</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Address</td>
                            <td><?php echo e($trainer->users->address); ?></td>
                        </tr>
                        <tr>
                            <td>City</td>
                            <td><?php echo e($trainer->users->city); ?></td>
                        </tr>
                        <tr>
                            <td>State</td>
                            <td><?php echo e($trainer->users->state); ?></td>
                        </tr>
                        <tr>
                            <td>Country</td>
                            <td><?php echo e($trainer->users->country); ?></td>
                        </tr>
                        <tr>
                            <td>Landmark</td>
                            <td><?php echo e($trainer->users->landmark); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-trainer-social-media" role="tabpanel"
        aria-labelledby="v-pills-trainer-social-media-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Trainer Social Media</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Website</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($trainer->website); ?>"><?php echo e($trainer->website); ?></a></td>
                        </tr>
                        <tr>
                            <td>FaceBook</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($trainer->users->fb_link); ?>"><?php echo e($trainer->users->fb_link); ?></a></td>
                        </tr>
                        <tr>
                            <td>Twitter</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($trainer->users->twitter_link); ?>"><?php echo e($trainer->users->twitter_link); ?></a>
                            </td>
                        </tr>
                        <tr>
                            <td>S.M Link</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($trainer->users->social_media_1); ?>"><?php echo e($trainer->users->social_media_1); ?></a>
                            </td>
                        </tr>
                        <tr>
                            <td>S.M Link</td>
                            <td><a class="text-decoration-none"
                                    href="<?php echo e($trainer->users->social_media_2); ?>"><?php echo e($trainer->users->social_media_2); ?></a>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-trainer-education-info" role="tabpanel"
        aria-labelledby="v-pills-trainer-education-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Trainer Education</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Specialization</td>
                            <td><?php echo e($trainer->specialization); ?></td>
                        </tr>
                        <tr>
                            <td>University</td>
                            <td><?php echo e($trainer->university); ?></td>
                        </tr>
                        <tr>
                            <td>Graduation Date</td>
                            <td><?php echo e($trainer->graduation_date); ?></td>
                        </tr>
                        <tr>
                            <td>Expereience</td>
                            <td><?php echo e($trainer->expereience); ?></td>
                        </tr>
                        <tr>
                            <td>Qualification</td>
                            <td><?php echo e($trainer->qualification); ?></td>
                        </tr>
                        <tr>
                            <td>Qualification Other</td>
                            <td><?php echo e($trainer->qualification_other); ?></td>
                        </tr>
                        <tr>
                            <td>Membership</td>
                            <td><?php echo e($trainer->membership); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="tab-pane fade" id="v-pills-trainer-experience-info" role="tabpanel"
        aria-labelledby="v-pills-trainer-experience-info-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Trainer Experience</div>
            </div>
            <div class="panel-body p-3">
                <table class="table table-striped user-table table-borderless">
                    <tbody>
                        <tr>
                            <td>Previous Job</td>
                            <td><?php echo e($trainer->previous_job); ?></td>
                        </tr>
                        <tr>
                            <td>Previous Job Address</td>
                            <td><?php echo e($trainer->previous_job_address); ?></td>
                        </tr>
                        <tr>
                            <td>Previous Job Country</td>
                            <td><?php echo e($trainer->previous_job_country); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    

    
    <div class="tab-pane fade" id="v-pills-user-sendwhatsapp" role="tabpanel"
        aria-labelledby="v-pills-user-sendwhatsapp-tab">
        <div class="panel panel-default">
            <div class="panel-head">
                <div class="panel-title border-bottom mb-3 p-3 font-weight-lighter h5">Send Whatsapp to Trainer
                </div>
            </div>
            <p></p>
            <form>
                <div class="panel-body p-3">
                    <div class="form-group">
                        <label>To</label>
                        <input type="text" value="asdfasd fsdfas" class="form-control" readonly="">
                    </div>
                    <div class="form-group">
                        <label>Message</label>
                        <textarea class="form-control" placeholder="Enter Message . . ." id="whatsapp_message" rows="10"></textarea>
                    </div>
                </div>
                <div class="panel-footer text-center">
                    <a class="btn btn-outline-primary" onclick="send_whatsapp()">Send</a>
                    <script>
                        function send_whatsapp() {
                            let mobile = "<?php echo e($trainer->users->phone); ?>";
                            let message = document.getElementById("whatsapp_message").value;
                            window.open('https://api.whatsapp.com/send?phone=' + mobile + '&text=' + message);
                            // window.location.href = "https://v6.devclinic.tps-egy.com/admin/index.php?route=patient/view&id=4", true;
                        }
                    </script>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\assignments\resources\views/trainers/view.blade.php ENDPATH**/ ?>