

<?php $__env->startSection('title'); ?>
    All Fathers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    Fathers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li>Fathers</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createFather')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Father
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col">Image</th>
    <th scope="col">Father</th>
    <th scope="col">Nationality</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $student_father_profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student_father_profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row"  class="imageTitle">
                <?php if($student_father_profile->father_image !== null&& $student_father_profile->father_image !== ''): ?>
                    <img class="image-fload" width="100px" height="100px"
                        src='<?php echo e(asset("uploads/$student_father_profile->father_image")); ?>'
                        alt="<?php echo e($student_father_profile->father_name); ?>">
                <?php else: ?>
                <h2> <?php echo e($student_father_profile->father_name[0]); ?></h2>
                <?php endif; ?>
            </th>
            <td class="Zindex Zindex1">
                <h6 class="col-4"> name </h6>
                <a class="text-decoration-none col-8" href="<?php echo e(route('viewFather', $student_father_profile->id)); ?>">
                    <p class="text-custome m-0 "><?php echo e($student_father_profile->father_name); ?></p>
                </a>
                <h6 class="col-4"> email </h6>
                <p class="m-0  col-8"><?php echo e($student_father_profile->father_email); ?></p>
                <h6 class="col-4"> phone </h6>
                <p class="m-0  col-8"><?php echo e($student_father_profile->father_phone); ?></p>
            </td>
            <td class="Zindex">
                <h6 class="col-4"> nationality </h6>
                <p class="m-0  col-8"><?php echo e($student_father_profile->father_nationality); ?></p>
            </td>
            <td class="Zindex">
                <h6 class="col-4"> Created By </h6>
                <a class="text-decoration-none  col-8" href="<?php echo e(route('viewUser', $student_father_profile->father_created_by)); ?>">
                    <p class="text-custome m-0  ">
                        <?php echo e($student_father_profile->createdPerson->full_name); ?></p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('viewFather', $student_father_profile->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('editFather', $student_father_profile->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <?php if(Auth::user()->role == "super_admin" || Auth::user()->role == "owner" ): ?>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('deleteFather', $student_father_profile->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\assignments\resources\views/fathers/list.blade.php ENDPATH**/ ?>