

<?php $__env->startSection('title'); ?>
    All Business Locations
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    Business Locations
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li>Business Locations</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createBusinessLocation')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Business Location
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col">logo</th>
    <th scope="col">Business Name</th>
    <th scope="col">Address</th>
    
    <th scope="col">Status</th>
    <th scope="col">Owner Name</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business_location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row">
                <?php if($business_location->image !== null): ?>
                    <img class="image-fload" width="100px" height="100px"
                        src='<?php echo e(asset("uploads/$business_location->image")); ?>'
                        alt="<?php echo e($business_location->business_name); ?>">
                <?php else: ?>
                    No Logo
                <?php endif; ?>
            </th>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewBusinessLocation', $business_location->id)); ?>">
                    <p class="text-primary m-0 px-3"><?php echo e($business_location->business_name); ?></p>
                </a>
                <p class="m-0 px-3"><?php echo e($business_location->email); ?></p>
                <p class="m-0 px-3"><?php echo e($business_location->phone); ?></p>
                <p class="m-0 px-3"><?php echo e($business_location->alternative_phone); ?></p>
            </td>
            <td>
                <p class="m-0 px-3"><?php echo e($business_location->address); ?></p>
            </td>
            
            <td>
                <?php if($business_location->is_active == 'Active'): ?>
                <p class="m-0 px-3 text-success">Active</p>
                <?php else: ?>
                <p class="m-0 px-3 text-danger">InActive</p>
                <?php endif; ?>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewUser', $business_location->owner_id)); ?>">
                    <p class="m-0 px-3"><?php echo e($business_location->owner->user_name); ?></p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewUser', $business_location->created_by)); ?>">
                    <p class="m-0 px-3"><?php echo e($business_location->createdPerson->user_name); ?></p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('viewBusinessLocation', $business_location->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-primary"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('editBusinessLocation', $business_location->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="<?php echo e(route('deleteBusinessLocation', $business_location->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/business-locations/list.blade.php ENDPATH**/ ?>