

<?php $__env->startSection('title'); ?>
    All Mothers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-title'); ?>
    Mothers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-navigation'); ?>
    <li>Mothers</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-new-button'); ?>
    <a href="<?php echo e(route('createMother')); ?>" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Mother
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-header'); ?>
    <th scope="col">#</th>
    <th scope="col">Image</th>
    <th scope="col">Mother</th>
    <th scope="col">Nationality</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-body'); ?>
    <?php $__currentLoopData = $student_mother_profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student_mother_profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <th scope="row">
                <?php if($student_mother_profile->mother_image !== null): ?>
                    <img class="image-fload" width="100px" height="100px"
                        src='<?php echo e(asset("uploads/$student_mother_profile->mother_image")); ?>'
                        alt="<?php echo e($student_mother_profile->mother_name); ?>">
                <?php else: ?>
                    No Mother Image
                <?php endif; ?>
            </th>
            <td>
                <a class="text-decoration-none" href="<?php echo e(route('viewMother', $student_mother_profile->id)); ?>">
                    <p class="text-primary m-0 px-3"><?php echo e($student_mother_profile->mother_name); ?></p>
                </a>
                <p class="m-0 px-3"><?php echo e($student_mother_profile->mother_email); ?></p>
                <p class="m-0 px-3"><?php echo e($student_mother_profile->mother_phone); ?></p>
            </td>
            <td>
                <p class="m-0 px-3"><?php echo e($student_mother_profile->mother_nationality); ?></p>
            </td>
            <td>
                <a href="<?php echo e(route('viewUser', $student_mother_profile->mother_created_by)); ?>">
                    <p class="text-primary m-0 px-3">
                        <?php echo e($student_mother_profile->createdPerson->full_name); ?></p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('viewMother', $student_mother_profile->id)); ?>">
                                <i class="fa-solid fa-eye me-2 text-primary"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('editMother', $student_mother_profile->id)); ?>">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="<?php echo e(route('deleteMother', $student_mother_profile->id)); ?>">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-table-inside-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('list-pagination'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\assignments\resources\views/mothers/list.blade.php ENDPATH**/ ?>