

<?php $__env->startSection('title'); ?>
    Edit User
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-title'); ?>
    <?php echo e(__('users.edit_user')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-navigation'); ?>
    <li><a class="text-decoration-none" href="<?php echo e(route('allUsers')); ?>"><?php echo e(__('users.list_users')); ?></a></li>
    <li><?php echo e(__('users.edit_user')); ?> - <?php echo e($user->full_name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('form-tabs-li'); ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-primary"
            type="button" role="tab" aria-controls="pills-basic-primary"
            aria-selected="true"><?php echo e(__('users.basic_info')); ?></button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-address-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-address-primary" type="button" role="tab" aria-controls="pills-address-primary"
            aria-selected="false"><?php echo e(__('users.address_info')); ?></button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-social-links"
            type="button" role="tab" aria-controls="pills-social-links"
            aria-selected="false"><?php echo e(__('users.social_links')); ?></button>
    </li>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('form-tabs-content'); ?>
    <form class="needs-validation" method="POST" action="<?php echo e(route('updateUser', $user->id)); ?>"
        enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="tab-content" id="pills-tabContent">
            
            <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel"
                aria-labelledby="pills-basic-primary-tab">

                <div class="row">

                    
                    <div class="col-md-4 mt-4">
                        <label for="full_name" class="form-label"><?php echo e(__('users.full_name')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="full_name" aria-describedby="nameHelp"
                                placeholder="<?php echo e(__('users.enter_full_name')); ?>" name="full_name"
                                value="<?php echo e(old('full_name') ?? $user->full_name); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="email" class="form-label"><?php echo e(__('users.email_address')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="email" aria-describedby="email"
                                placeholder="<?php echo e(__('users.enter_email_address')); ?>" name="email"
                                value="<?php echo e(old('email') ?? $user->email); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="is_active" class="form-label"><?php echo e(__('users.is_active_question')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="is_active" name="is_active" required>
                                <option value="Active"
                                    <?php if(old('is_active') == null): ?> <?php echo e($user->is_active == 'Active' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('is_active') == 'Active' ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e(__('users.active')); ?></option>
                                <option value="InActive"
                                    <?php if(old('is_active') == null): ?> <?php echo e($user->is_active == 'InActive' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('is_active') == 'InActive' ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e(__('users.in_active')); ?></option>
                            </select>

                        </div>
                    </div>

                    <?php /*
                                                            
                                                            <div class="col-md-2 mt-4">
                                                                <label for="allow_login" class="form-label">Allow Login</label>
                                                                <div class="input-group has-validation">
                                                                    <span class="input-group-text" id="inputGroupPrepend">
                                                                        <i class="fa-solid fa-check"></i>
                                                                    </span>
                                                                    <select class="form-control text-start custom-select" id="allow_login" name="allow_login" required>
                                                                        <option value="Allowable" @if (old('allow_login')==null) {{ $user->allow_login == 'Allowable' ? 'selected' : '' }} @else {{ old('allow_login') == 'Allowable' ? 'selected' : '' }} @endif>
                                                                            Allowable</option>
                                                                        <option value="Not Allowable" @if (old('allow_login')==null) {{ $user->allow_login == 'Not Allowable' ? 'selected' : '' }} @else {{ old('allow_login') == 'Not Allowable' ? 'selected' : '' }} @endif>
                                                                            Not Allowable</option>
                                                
                                                                    </select>
                                                                
                                                                </div>
                                                            </div>
                                                            */
                    ?>

                    
                    <div class="col-md-4 mt-4">
                        <label for="phone" class="form-label"><?php echo e(__('users.mobile_number')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="phone"
                                placeholder="<?php echo e(__('users.enter_mobile_number')); ?>" name="phone"
                                value="<?php echo e(old('phone') ?? $user->phone); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="alternative_phone"
                            class="form-label"><?php echo e(__('users.alternative_mobile_number')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="alternative_phone"
                                placeholder="<?php echo e(__('users.enter_alternative_mobile_number')); ?>"
                                name="alternative_phone"
                                value="<?php echo e(old('alternative_phone') ?? $user->alternative_phone); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="contact_number" class="form-label"><?php echo e(__('users.contact_number')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="contact_number"
                                placeholder="<?php echo e(__('users.enter_contact_number')); ?>" name="contact_number"
                                value="<?php echo e(old('contact_number') ?? $user->contact_number); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="nationality" class="form-label"><?php echo e(__('users.nationality')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="nationality"
                                placeholder="<?php echo e(__('users.enter_nationality')); ?>" name="nationality"
                                value="<?php echo e(old('nationality') ?? $user->nationality); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="national_number" class="form-label"><?php echo e(__('users.national_number')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-id-card"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="national_number"
                                placeholder="<?php echo e(__('users.enter_national_number')); ?>" name="national_number"
                                value="<?php echo e(old('national_number') ?? $user->national_number); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-2 mt-4">
                        <?php if($user->image !== null): ?>
                            <div class="form-group">
                                <img class="image-fload" width="100%" height="100%"
                                    src='<?php echo e(asset("uploads/$user->image")); ?>' alt="<?php echo e($user->full_name); ?>">
                            </div>
                        <?php else: ?>
                            <br>
                            <p class="filelabel"><?php echo e(__('users.no_user_image')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-2 mt-4">
                        <label for="image_input" class="form-label filelabel">
                            <i class="fa fa-paperclip">
                            </i>
                            <span class="title">
                                <?php echo e(__('users.upload_image')); ?>

                            </span>
                            <input class="FileUpload1 form-control" id="image_input" name="image" type="file" />
                        </label>
                    </div>


                    
                    <div class="col-md-4 mt-4">
                        <label for="dob" class="form-label"><?php echo e(__('users.dob')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="dob"
                                placeholder="<?php echo e(__('users.enter_dob')); ?>" name="dob"
                                value="<?php echo e(old('dob') ?? $user->dob); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="gender" class="form-label"><?php echo e(__('users.gender')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="gender" name="gender" required>
                                <option value="" disabled><?php echo e(__('users.choose_option')); ?></option>
                                <option value="Male"
                                    <?php if(old('gender') == null): ?> <?php echo e($user->gender == 'Male' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('gender') == 'Male' ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e(__('users.male')); ?></option>
                                <option value="Female"
                                    <?php if(old('gender') == null): ?> <?php echo e($user->gender == 'Female' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('gender') == 'Female' ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e(__('users.female')); ?></option>
                            </select>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="blood_group" class="form-label"><?php echo e(__('users.blood_group')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="blood_group" name="blood_group">
                                <option value=""><?php echo e(__('users.choose_option')); ?></option>
                                <option value="A+"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'A+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A+' ? 'selected' : ''); ?> <?php endif; ?>>
                                    A+</option>
                                <option value="A-"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'A-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A-' ? 'selected' : ''); ?> <?php endif; ?>>
                                    A-</option>
                                <option value="B+"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'B+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'B+' ? 'selected' : ''); ?> <?php endif; ?>>
                                    B+</option>
                                <option value="B-"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'B-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'B-' ? 'selected' : ''); ?> <?php endif; ?>>
                                    B-</option>
                                <option value="O+"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'O+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A+' ? 'selected' : ''); ?> <?php endif; ?>>
                                    O+</option>
                                <option value="O-"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'O-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A-' ? 'selected' : ''); ?> <?php endif; ?>>
                                    O-</option>
                                <option value="AB+"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'AB+' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A+' ? 'selected' : ''); ?> <?php endif; ?>>
                                    AB+</option>
                                <option value="AB-"
                                    <?php if(old('blood_group') == null): ?> <?php echo e($user->blood_group == 'AB-' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('blood_group') == 'A-' ? 'selected' : ''); ?> <?php endif; ?>>
                                    AB-</option>
                            </select>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="language" class="form-label"><?php echo e(__('users.mother_language')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="language"
                                placeholder="<?php echo e(__('users.enter_mother_language')); ?>" name="language"
                                value="<?php echo e(old('language') ?? $user->language); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="marital_status" class="form-label"><?php echo e(__('users.marital_status')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="marital_status"
                                name="marital_status" required>
                                <option value=""><?php echo e(__('users.choose_option')); ?></option>
                                <option value="Single"
                                    <?php if(old('marital_status') == null): ?> <?php echo e($user->marital_status == 'Single' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('marital_status') == 'Single' ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e(__('users.single')); ?></option>
                                <option value="Married"
                                    <?php if(old('marital_status') == null): ?> <?php echo e($user->marital_status == 'Married' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('marital_status') == 'Married' ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e(__('users.married')); ?></option>
                                <option value="Divorced"
                                    <?php if(old('marital_status') == null): ?> <?php echo e($user->marital_status == 'Divorced' ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('marital_status') == 'Divorced' ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e(__('users.divorced')); ?></option>
                            </select>

                        </div>
                    </div>

                </div>

                <div class="dotted-seprator mt-4 "></div>

                <div class="row">

                    
                    <div class="col-md-4 mt-4">
                        <label for="user_name" class="form-label"><?php echo e(__('users.user_name')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="user_name"
                                aria-describedby="user_name" placeholder="<?php echo e(__('users.enter_user_name')); ?>"
                                name="user_name" value="<?php echo e(old('user_name') ?? $user->user_name); ?>" required>

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="user_name" class="form-label"><?php echo e(__('users.changing_user_password')); ?></label>
                        <div class="input-group has-validation">
                            <a class="btn btn-outline-primary btn-sm me-2" data-bs-toggle="modal"
                                data-bs-target="#exampleModal">
                                <i class="fa-solid fa-plus me-2"></i><?php echo e(__('users.change_password')); ?>

                            </a>
                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="businessLocations"
                            class="form-label"><?php echo e(__('users.business_location_name')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="businessLocations"
                                name="business_id" required>
                                <option value="" disabled><?php echo e(__('users.choose_option')); ?></option>
                                <?php $__currentLoopData = $business_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business_location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($business_location->id); ?>"
                                        <?php if(old('business_id') == null): ?> <?php echo e($user->business_id == $business_location->id ? 'selected' : ''); ?> <?php else: ?> <?php echo e(old('business_id') == $business_location->id ? 'selected' : ''); ?> <?php endif; ?>>
                                        <?php echo e($business_location->business_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                        </div>
                    </div>


                </div>
            </div>



            
            <div class="tab-pane  fade px-3" id="pills-address-primary" role="tabpanel"
                aria-labelledby="pills-address-primary-tab">

                <div class="row">

                    
                    <div class="col-md-4 mt-4">
                        <label for="address" class="form-label"><?php echo e(__('users.address')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="address"
                                aria-describedby="address" placeholder="<?php echo e(__('users.enter_address')); ?>"
                                name="address" value="<?php echo e(old('address') ?? $user->address); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="city" class="form-label"><?php echo e(__('users.city')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="city" aria-describedby="city"
                                placeholder="<?php echo e(__('users.enter_city')); ?>" name="city"
                                value="<?php echo e(old('city') ?? $user->city); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="state" class="form-label"><?php echo e(__('users.state')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="state"
                                aria-describedby="state" placeholder="<?php echo e(__('users.enter_state')); ?>" name="state"
                                value="<?php echo e(old('state') ?? $user->state); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="country" class="form-label"><?php echo e(__('users.country')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="country"
                                aria-describedby="country" placeholder="<?php echo e(__('users.enter_country')); ?>"
                                name="country" value="<?php echo e(old('country') ?? $user->country); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="landmark" class="form-label"><?php echo e(__('users.landmark')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="landmark"
                                aria-describedby="landmark" placeholder="<?php echo e(__('users.enter_landmark')); ?>"
                                name="landmark" value="<?php echo e(old('landmark') ?? $user->landmark); ?>">

                        </div>
                    </div>


                </div>
            </div>



            
            <div class="tab-pane fade  px-3" id="pills-social-links" role="tabpanel"
                aria-labelledby="pills-social-links-tab">

                <div class="row">

                    
                    <div class="col-md-4 mt-4">
                        <label for="fb_link" class="form-label"><?php echo e(__('users.facebook_link')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="fb_link"
                                placeholder="<?php echo e(__('users.enter_facebook_link')); ?>" name="fb_link"
                                value="<?php echo e(old('fb_link') ?? $user->fb_link); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="twitter_link" class="form-label"><?php echo e(__('users.twitter_link')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="twitter_link"
                                placeholder="<?php echo e(__('users.enter_twitter_link')); ?>" name="twitter_link"
                                value="<?php echo e(old('twitter_link') ?? $user->twitter_link); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="social_media_1" class="form-label"><?php echo e(__('users.social_media_link')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="social_media_1"
                                placeholder="<?php echo e(__('users.enter_social_media_link')); ?>" name="social_media_1"
                                value="<?php echo e(old('social_media_1') ?? $user->social_media_1); ?>">

                        </div>
                    </div>

                    
                    <div class="col-md-4 mt-4">
                        <label for="social_media_2" class="form-label"><?php echo e(__('users.social_media_link_2')); ?></label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="social_media_2"
                                placeholder="E<?php echo e(__('users.enter_social_media_link_2')); ?>" name="social_media_2"
                                value="<?php echo e(old('social_media_2') ?? $user->social_media_2); ?>">

                        </div>
                    </div>


                </div>
            </div>


        </div>
        <div class="col-12 mt-5">
            <button class="btn btn-outline-primary" type="submit"><?php echo e(__('users.save')); ?></button>
        </div>
    </form>
<?php $__env->stopSection(); ?>



<!-- Change password Modal -->
<form method="POST" action="<?php echo e(route('updateUserPassword', $user->id)); ?>"enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('users.changing_user_password')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="password"><?php echo e(__('users.new_password')); ?></label>
                        <input type="password" data-password="myPass" class="form-control" id="password"
                            aria-describedby="passwordHelp" placeholder="Password" name="password">
                        <small id="passwordHelp" class="form-text text-muted"><?php echo e(__('users.edit_password_note')); ?></small>
                    </div>

                    <div class="form-group">
                        <label for="confirm_password"><?php echo e(__('users.confirm_new_password')); ?></label>
                        <input type="password" class="form-control" id="confirm_password"
                            aria-describedby="confirmPasswordHelp" placeholder="Password"
                            onblur="CheckPassword(this)" required>
                        <div class="invalid-feedback invalid-Password">
                            <?php echo e(__('users.not_match_passwords')); ?>

                        </div>
                    </div>




                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('users.close')); ?></button>
                    <button class="btn btn-outline-primary py-2 px-5" id="submit" disabled
                        type="submit"><?php echo e(__('users.submit')); ?></button>
                </div>
            </div>
        </div>
    </div>
</form>

<?php echo $__env->make('layouts.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\assignments\resources\views/users/edit.blade.php ENDPATH**/ ?>